/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class BuildAllAction
extends ActionDelegate
implements IWorkbenchWindowPulldownDelegate2,
IObjectActionDelegate,
IMenuCreator {
    private static final String TIP_ALL = Messages.getString("BuildAllAction.0");
    private static final String LBL_ALL = Messages.getString("BuildAllAction.1");
    private static final String JOB_MSG = Messages.getString("BuildAllAction.2");
    private static final String ERR_MSG = Messages.getString("BuildAllAction.3");
    private static final String LBL_SEL = Messages.getString("BuildAllAction.4");
    private static final String TIP_SEL = Messages.getString("BuildAllAction.5");
    private static final String DLG_TEXT = Messages.getString("BuildAllAction.6");
    private static final String DLG_TITLE = Messages.getString("BuildAllAction.7");
    protected ArrayList projects = null;
    private ActionContributionItem it_all = null;
    private ActionContributionItem it_sel = null;

    public void selectionChanged(IAction action, ISelection selection) {
        Object[] obs;
        this.projects = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obs = ((IStructuredSelection)selection).toArray()).length > 0) {
            int i = 0;
            while (i < obs.length) {
                ICConfigurationDescription[] cfgds;
                ICProjectDescription prjd;
                IProject prj = null;
                if (obs[i] instanceof IProject) {
                    prj = (IProject)obs[i];
                } else if (obs[i] instanceof ICProject) {
                    prj = ((ICProject)obs[i]).getProject();
                }
                if (prj != null && CoreModel.getDefault().isNewStyleProject(prj) && (prjd = CoreModel.getDefault().getProjectDescription(prj, false)) != null && (cfgds = prjd.getConfigurations()) != null && cfgds.length > 0) {
                    if (this.projects == null) {
                        this.projects = new ArrayList();
                    }
                    this.projects.add(prj);
                }
                ++i;
            }
        }
        action.setEnabled(this.projects != null);
        if (this.projects != null && this.it_sel != null) {
            this.it_sel.getAction().setEnabled(this.projects.size() == 1);
        }
        action.setMenuCreator((IMenuCreator)this);
    }

    public void run(IAction action) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return this.fillMenu(new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return this.fillMenu(new Menu(parent));
    }

    protected Menu fillMenu(Menu menu) {
        this.it_all = new ActionContributionItem((IAction)new LocalAction(true));
        this.it_sel = new ActionContributionItem((IAction)new LocalAction(false));
        if (this.projects != null) {
            this.it_sel.getAction().setEnabled(this.projects.size() == 1);
        }
        this.it_all.fill(menu, -1);
        this.it_sel.fill(menu, -1);
        return menu;
    }

    private Object[] openDialog(Object[] cfgds) {
        if (cfgds == null || cfgds.length == 0) {
            return null;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), (Object)cfgds, new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null || !(element instanceof ICConfigurationDescription)) {
                    return null;
                }
                return ((ICConfigurationDescription)element).getName();
            }
        }, DLG_TEXT);
        dialog.setTitle(DLG_TITLE);
        dialog.setInitialSelections(cfgds);
        return dialog.open() == 0 ? dialog.getResult() : null;
    }

    private static final class BuildFilesJob
    extends Job {
        Object[] cfs;

        BuildFilesJob(Object[] _cfs) {
            super(String.valueOf(JOB_MSG) + ((ICConfigurationDescription)_cfs[0]).getProjectDescription().getName());
            this.cfs = _cfs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IConfiguration[] cf = new IConfiguration[this.cfs.length];
            int i = 0;
            while (i < this.cfs.length) {
                cf[i] = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)((ICConfigurationDescription)this.cfs[i]));
                ++i;
            }
            try {
                ManagedBuildManager.buildConfigurations((IConfiguration[])cf, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                return new Status(4, ERR_MSG, e.getLocalizedMessage());
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    private class LocalAction
    extends Action {
        boolean forAll;

        LocalAction(boolean mode) {
            this.forAll = mode;
            this.setText(this.forAll ? LBL_ALL : LBL_SEL);
            this.setToolTipText(this.forAll ? TIP_ALL : TIP_SEL);
        }

        public void run() {
            if (BuildAllAction.this.projects == null || BuildAllAction.this.projects.isEmpty()) {
                return;
            }
            Iterator it = BuildAllAction.this.projects.iterator();
            if (this.forAll) {
                while (it.hasNext()) {
                    this.processProject((IProject)it.next());
                }
            } else if (it.hasNext()) {
                this.processProject((IProject)it.next());
            }
        }

        private void processProject(IProject prj) {
            ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
            if (prjd == null) {
                return;
            }
            Object[] cfgds = prjd.getConfigurations();
            if (!this.forAll) {
                cfgds = BuildAllAction.this.openDialog(cfgds);
            }
            if (cfgds == null || cfgds.length == 0) {
                return;
            }
            BuildFilesJob buildFilesJob = new BuildFilesJob(cfgds);
            buildFilesJob.schedule();
        }
    }
}

