/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionComboFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsUI;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControlFieldEditor;
import org.eclipse.cdt.managedbuilder.ui.properties.StringFieldEditorM;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class BuildOptionSettingsUI
extends AbstractToolSettingUI {
    private Map fieldsMap = new HashMap();
    private IOptionCategory category;
    private IHoldsOptions optionHolder;
    private Map fieldEditorsToParentMap = new HashMap();

    public BuildOptionSettingsUI(AbstractCBuildPropertyTab page, IResourceInfo info, IHoldsOptions optionHolder, IOptionCategory _category) {
        super(info);
        this.category = _category;
        this.optionHolder = optionHolder;
        this.buildPropPage = page;
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String optId = this.getToolSettingsPrefStore().getOptionId(opt);
            IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
            IResourceInfo config = this.fInfo;
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionVisible((IBuildObject)config, holder, opt)) {
                try {
                    class TooltipBooleanFieldEditor
                    extends BooleanFieldEditor {
                        final /* synthetic */ BuildOptionSettingsUI this$0;

                        public TooltipBooleanFieldEditor(BuildOptionSettingsUI buildOptionSettingsUI, String name, String labelText, String tooltip, Composite parent, String contextId) {
                            this.this$0 = buildOptionSettingsUI;
                            super(name, labelText, parent);
                            this.getChangeControl(parent).setToolTipText(tooltip);
                            if (!contextId.equals("")) {
                                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getChangeControl(parent), contextId);
                            }
                        }
                    }
                    Object fieldEditor;
                    Composite fieldEditorParent = this.getFieldEditorParent();
                    switch (opt.getValueType()) {
                        case 2: {
                            Object stringField;
                            switch (opt.getBrowseType()) {
                                case 2: {
                                    stringField = new DirectoryFieldEditor(optId, opt.getName(), fieldEditorParent);
                                    break;
                                }
                                case 1: {
                                    stringField = new FileFieldEditor(optId, opt.getName(), fieldEditorParent);
                                    break;
                                }
                                case 0: {
                                    final StringFieldEditorM local = new StringFieldEditorM(optId, opt.getName(), fieldEditorParent);
                                    stringField = local;
                                    local.getTextControl().addModifyListener(new ModifyListener(){

                                        public void modifyText(ModifyEvent e) {
                                            local.valueChanged();
                                        }
                                    });
                                    break;
                                }
                                default: {
                                    throw new BuildException(null);
                                }
                            }
                            stringField.getTextControl(fieldEditorParent).setToolTipText(opt.getToolTip());
                            stringField.getLabelControl(fieldEditorParent).setToolTipText(opt.getToolTip());
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)stringField.getTextControl(fieldEditorParent), opt.getContextId());
                            fieldEditor = stringField;
                            break;
                        }
                        case 0: {
                            fieldEditor = new TooltipBooleanFieldEditor(this, optId, opt.getName(), opt.getToolTip(), fieldEditorParent, opt.getContextId());
                            break;
                        }
                        case 1: {
                            String selId = opt.getSelectedEnum();
                            String sel = opt.getEnumName(selId);
                            String[] enumNames = opt.getApplicableValues();
                            Vector<String> enumValidList = new Vector<String>();
                            int i = 0;
                            while (i < enumNames.length) {
                                if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                                    enumValidList.add(enumNames[i]);
                                }
                                ++i;
                            }
                            Object[] enumValidNames = new String[enumValidList.size()];
                            enumValidList.copyInto(enumValidNames);
                            fieldEditor = new BuildOptionComboFieldEditor(optId, opt.getName(), opt.getToolTip(), opt.getContextId(), (String[])enumValidNames, sel, fieldEditorParent);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            fieldEditor = new FileListControlFieldEditor(optId, opt.getName(), opt.getToolTip(), opt.getContextId(), fieldEditorParent, opt.getBrowseType());
                            break;
                        }
                        default: {
                            throw new BuildException(null);
                        }
                    }
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, (FieldEditor)fieldEditor, fieldEditorParent);
                    this.addField((FieldEditor)fieldEditor);
                    this.fieldsMap.put(optId, fieldEditor);
                    this.fieldEditorsToParentMap.put(fieldEditor, fieldEditorParent);
                }
                catch (BuildException buildException) {}
            }
            ++index;
        }
    }

    public boolean isFor(Object holder, Object cat) {
        return holder instanceof IHoldsOptions && cat != null && cat instanceof IOptionCategory && this.optionHolder == this.optionHolder && cat.equals(this.category);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IConfiguration realCfg = null;
        IConfiguration handler = null;
        realCfg = this.buildPropPage.getCfg();
        if (realCfg == null) {
            return false;
        }
        handler = realCfg;
        Object[][] clonedOptions = this.category.getOptions(this.fInfo, this.optionHolder);
        int i = 0;
        while (i < clonedOptions.length) {
            IOption realOption;
            IHoldsOptions clonedHolder = (IHoldsOptions)clonedOptions[i][0];
            if (clonedHolder == null) break;
            IOption clonedOption = (IOption)clonedOptions[i][1];
            IHoldsOptions realHolder = clonedHolder;
            if (realHolder != null && (realOption = clonedOption) != null) {
                try {
                    IOption setOption = null;
                    switch (clonedOption.getValueType()) {
                        case 0: {
                            boolean boolVal = clonedOption.getBooleanValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                            break;
                        }
                        case 1: {
                            String enumVal = clonedOption.getStringValue();
                            String enumId = clonedOption.getEnumeratedId(enumVal);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                            break;
                        }
                        case 2: {
                            String strVal = clonedOption.getStringValue();
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                            setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                            break;
                        }
                    }
                    if (setOption == null) {
                        setOption = realOption;
                    }
                    setOption.getValueHandler().handleValue((IBuildObject)handler, setOption.getOptionHolder(), setOption, setOption.getValueHandlerExtraArgument(), 4);
                }
                catch (BuildException buildException) {
                }
                catch (ClassCastException classCastException) {}
            }
            ++i;
        }
        return ok;
    }

    public void updateFields() {
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IOptionApplicability applicabilityCalculator;
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String prefName = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(prefName) && (applicabilityCalculator = opt.getApplicabilityCalculator()) != null) {
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(prefName);
                Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
            }
            ++index;
        }
        Collection fieldsList = this.fieldsMap.values();
        Iterator iter = fieldsList.iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            editor.load();
        }
    }

    private void setFieldEditorEnablement(IHoldsOptions holder, IOption option, IOptionApplicability optionApplicability, FieldEditor fieldEditor, Composite parent) {
        if (optionApplicability == null) {
            return;
        }
        IResourceInfo config = this.fInfo;
        if (!optionApplicability.isOptionEnabled((IBuildObject)config, holder, option)) {
            fieldEditor.setEnabled(false, parent);
        } else {
            fieldEditor.setEnabled(true, parent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        Object source = event.getSource();
        IOption changedOption = null;
        IHoldsOptions changedHolder = null;
        String id = null;
        if (source instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)source;
            id = fe.getPreferenceName();
            Object[] option = this.getToolSettingsPrefStore().getOption(id);
            if (option != null) {
                changedOption = (IOption)option[1];
                changedHolder = (IHoldsOptions)option[0];
                try {
                    switch (changedOption.getValueType()) {
                        case 2: {
                            if (fe instanceof StringFieldEditor) {
                                String val = ((StringFieldEditor)fe).getStringValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)val);
                            }
                            break;
                        }
                        case 0: {
                            if (fe instanceof BooleanFieldEditor) {
                                boolean val = ((BooleanFieldEditor)fe).getBooleanValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (boolean)val);
                            }
                            break;
                        }
                        case 1: {
                            if (fe instanceof BuildOptionComboFieldEditor) {
                                String name = ((BuildOptionComboFieldEditor)fe).getSelection();
                                String enumId = changedOption.getEnumeratedId(name);
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String)(enumId != null && enumId.length() > 0 ? enumId : name));
                            }
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            if (fe instanceof FileListControlFieldEditor) {
                                String[] val = ((FileListControlFieldEditor)fe).getStringListValue();
                                ManagedBuildManager.setOption((IResourceInfo)this.fInfo, (IHoldsOptions)changedHolder, (IOption)changedOption, (String[])val);
                            }
                            break;
                        }
                    }
                }
                catch (BuildException buildException) {}
            }
        }
        Object[][] options = this.category.getOptions(this.fInfo, this.optionHolder);
        int index = 0;
        while (index < options.length) {
            IHoldsOptions holder = (IHoldsOptions)options[index][0];
            if (holder == null) break;
            IOption opt = (IOption)options[index][1];
            String optId = this.getToolSettingsPrefStore().getOptionId(opt);
            if (this.fieldsMap.containsKey(optId)) {
                IOptionApplicability applicabilityCalculator = opt.getApplicabilityCalculator();
                FieldEditor fieldEditor = (FieldEditor)this.fieldsMap.get(optId);
                try {
                    if (opt.getValueType() == 1) {
                        this.updateEnumList(fieldEditor, opt, holder, this.fInfo);
                    }
                }
                catch (BuildException buildException) {}
                if (applicabilityCalculator != null) {
                    Composite parent = (Composite)this.fieldEditorsToParentMap.get(fieldEditor);
                    this.setFieldEditorEnablement(holder, opt, applicabilityCalculator, fieldEditor, parent);
                }
            }
            ++index;
        }
        Iterator iter = this.fieldsMap.values().iterator();
        while (iter.hasNext()) {
            FieldEditor editor = (FieldEditor)iter.next();
            if (id != null && id.equals(editor.getPreferenceName())) continue;
            editor.load();
        }
    }

    public void setValues() {
        this.updateFields();
    }

    protected void updateEnumList(FieldEditor fieldEditor, IOption opt, IHoldsOptions holder, IResourceInfo config) throws BuildException {
        String[] enumNames = opt.getApplicableValues();
        String selectedEnum = opt.getSelectedEnum();
        String selectedEnumName = opt.getEnumName(selectedEnum);
        String defaultEnumId = (String)opt.getDefaultValue();
        String defaultEnumName = opt.getEnumName(defaultEnumId);
        boolean selectNewEnum = true;
        boolean selectDefault = false;
        Vector<String> enumValidList = new Vector<String>();
        int i = 0;
        while (i < enumNames.length) {
            if (opt.getValueHandler().isEnumValueAppropriate((IBuildObject)config, opt.getOptionHolder(), opt, opt.getValueHandlerExtraArgument(), enumNames[i])) {
                if (selectedEnumName.equals(enumNames[i])) {
                    selectNewEnum = false;
                }
                if (defaultEnumName.equals(enumNames[i])) {
                    selectDefault = true;
                }
                enumValidList.add(enumNames[i]);
            }
            ++i;
        }
        Object[] enumValidNames = new String[enumValidList.size()];
        enumValidList.copyInto(enumValidNames);
        if (selectNewEnum) {
            String selection = null;
            if (selectDefault) {
                selection = (String)opt.getDefaultValue();
            } else if (enumValidNames.length > 0) {
                selection = opt.getEnumeratedId((String)enumValidNames[0]);
            }
            ManagedBuildManager.setOption((IResourceInfo)config, (IHoldsOptions)holder, (IOption)opt, (String)selection);
        }
        ((BuildOptionComboFieldEditor)fieldEditor).setOptions((String[])enumValidNames);
        fieldEditor.load();
    }
}

