/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.refactoring.ASTManager;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameProcessorDelegate;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CRenameLocalProcessor
extends CRenameProcessorDelegate {
    private IScope fScope;

    public CRenameLocalProcessor(CRenameProcessor input, String kind, IScope scope) {
        super(input, kind);
        this.fScope = scope;
        this.setAvailableOptions(0);
        this.setOptionsForcingPreview(0);
    }

    protected int getAcceptedLocations(int selectedOptions) {
        return 0x90 | selectedOptions;
    }

    protected int getSearchScope() {
        return 1;
    }

    protected void analyzeTextMatches(ArrayList matches, IProgressMonitor monitor, RefactoringStatus status) {
        if (this.fScope != null) {
            IASTFileLocation loc;
            CRefactoringArgument argument = this.getArgument();
            ASTManager r = this.getAstManager();
            int[] nArray = new int[2];
            nArray[1] = Integer.MAX_VALUE;
            int[] result = nArray;
            IScope scope = argument.getScope();
            IASTNode node = null;
            try {
                node = ASTInternal.getPhysicalNodeOfScope((IScope)scope);
                if (argument.getBinding() instanceof IParameter) {
                    node = node.getParent();
                }
            }
            catch (DOMException e) {
                r.handleDOMException(argument.getTranslationUnit(), e, status);
            }
            if (node != null && (loc = ASTManager.getLocationInTranslationUnit(node)) != null) {
                result[0] = loc.getNodeOffset();
                result[1] = result[0] + loc.getNodeLength();
            }
            int[] range = result;
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                CRefactoringMatch m = (CRefactoringMatch)iter.next();
                int off = m.getOffset();
                if (off >= range[0] && off <= range[1]) continue;
                iter.remove();
            }
        }
        super.analyzeTextMatches(matches, monitor, status);
    }
}

