/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.refactoring.ASTManager;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRenameClassProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameGlobalProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameIncludeProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameLocalProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameMacroProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameMethodProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameProcessorDelegate;
import org.eclipse.cdt.internal.refactoring.CRenameTypeProcessor;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class CRenameProcessor
extends RenameProcessor {
    public static final String IDENTIFIER = "org.eclips.cdt.refactoring.RenameProcessor";
    private CRefactoringArgument fArgument;
    private CRenameProcessorDelegate fDelegate;
    private String fReplacementText;
    private String fWorkingSet;
    private int fScope;
    private int fSelectedOptions;
    private CRefactory fManager;
    private ASTManager fAstManager;

    public CRenameProcessor(CRefactory refactoringManager, CRefactoringArgument arg) {
        this.fManager = refactoringManager;
        this.fArgument = arg;
        this.fAstManager = new ASTManager(refactoringManager, arg);
    }

    public CRefactoringArgument getArgument() {
        return this.fArgument;
    }

    public Object[] getElements() {
        return new Object[]{this.fArgument.getBinding()};
    }

    public String getProcessorName() {
        String identifier;
        String result = null;
        if (this.fDelegate != null) {
            result = this.fDelegate.getProcessorName();
        }
        if (result == null && (identifier = this.getArgument().getName()) != null && identifier.length() > 0) {
            result = MessageFormat.format(Messages.getString("CRenameTopProcessor.wizard.title"), identifier);
        }
        if (result == null) {
            result = Messages.getString("CRenameTopProcessor.wizard.backup.title");
        }
        return result;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String identifier = null;
        RefactoringStatus status = new RefactoringStatus();
        if (this.fArgument != null) {
            this.fAstManager.analyzeArgument(pm, status);
            identifier = this.fArgument.getName();
        }
        if (identifier == null || identifier.length() < 1) {
            status.addFatalError(Messages.getString("CRenameTopProcessor.error.invalidTextSelection"));
            return status;
        }
        IFile file = this.fArgument.getSourceFile();
        IPath path = null;
        if (file != null) {
            path = file.getLocation();
        }
        if (path == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameTopProcessor.error.renameWithoutSourceFile"));
        }
        this.fDelegate = this.createDelegate();
        if (this.fDelegate == null) {
            status.addFatalError(Messages.getString("CRenameTopProcessor.error.invalidName"));
            return status;
        }
        RefactoringStatus s1 = this.fDelegate.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        status.merge(s1);
        return status;
    }

    private CRenameProcessorDelegate createDelegate() {
        switch (this.fArgument.getArgumentKind()) {
            case 1: {
                return new CRenameLocalProcessor(this, Messages.getString("CRenameTopProcessor.localVar"), this.fArgument.getScope());
            }
            case 2: {
                return new CRenameLocalProcessor(this, Messages.getString("CRenameTopProcessor.parameter"), this.fArgument.getScope());
            }
            case 3: {
                return new CRenameLocalProcessor(this, Messages.getString("CRenameTopProcessor.filelocalVar"), null);
            }
            case 4: {
                return new CRenameGlobalProcessor(this, Messages.getString("CRenameTopProcessor.globalVar"));
            }
            case 13: {
                return new CRenameGlobalProcessor(this, Messages.getString("CRenameTopProcessor.enumerator"));
            }
            case 5: {
                return new CRenameGlobalProcessor(this, Messages.getString("CRenameTopProcessor.field"));
            }
            case 6: {
                return new CRenameLocalProcessor(this, Messages.getString("CRenameTopProcessor.filelocalFunction"), null);
            }
            case 7: {
                return new CRenameGlobalProcessor(this, Messages.getString("CRenameTopProcessor.globalFunction"));
            }
            case 8: {
                return new CRenameMethodProcessor(this, Messages.getString("CRenameTopProcessor.virtualMethod"));
            }
            case 9: {
                return new CRenameMethodProcessor(this, Messages.getString("CRenameTopProcessor.method"));
            }
            case 14: {
                return new CRenameClassProcessor(this, Messages.getString("CRenameTopProcessor.type"));
            }
            case 15: {
                return new CRenameTypeProcessor(this, Messages.getString("CRenameTopProcessor.namespace"));
            }
            case 10: {
                return new CRenameTypeProcessor(this, Messages.getString("CRenameTopProcessor.type"));
            }
            case 11: {
                return new CRenameMacroProcessor(this, Messages.getString("CRenameTopProcessor.macro"));
            }
            case 12: {
                return new CRenameIncludeProcessor(this, Messages.getString("CRenameIncludeProcessor.includeDirective"));
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return this.fDelegate.checkFinalConditions(pm, context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fDelegate.createChange(pm);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getReplacementText(), true);
        String[] natures = this.getManager().getAffectedProjectNatures();
        ArrayList<RenameParticipant> result = new ArrayList<RenameParticipant>();
        IBinding binding = this.getArgument().getBinding();
        if (binding != null) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)binding, (RenameArguments)arguments, (String[])natures, (SharableParticipants)sharedParticipants)));
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public int getAvailableOptions() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getAvailableOptions();
    }

    public int getOptionsForcingPreview() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getOptionsForcingPreview();
    }

    public int getOptionsEnablingScope() {
        if (this.fDelegate == null) {
            return 0;
        }
        return this.fDelegate.getOptionsEnablingScope();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public int getScope() {
        return this.fScope;
    }

    public void setScope(int scope) {
        this.fScope = scope;
    }

    public int getSelectedOptions() {
        return this.fSelectedOptions;
    }

    public void setSelectedOptions(int selectedOptions) {
        this.fSelectedOptions = selectedOptions;
    }

    public String getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(String workingSet) {
        this.fWorkingSet = workingSet;
    }

    public String getReplacementText() {
        return this.fReplacementText;
    }

    public void setReplacementText(String replacementText) {
        this.fReplacementText = replacementText;
    }

    public CRefactory getManager() {
        return this.fManager;
    }

    public ASTManager getAstManager() {
        return this.fAstManager;
    }
}

