/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.refactoring.DocumentAdapter;
import org.eclipse.cdt.internal.refactoring.UndoCTextFileChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class CTextFileChange
extends TextFileChange {
    private ITranslationUnit fTranslationUnit = null;
    private IWorkingCopy fWorkingCopy;
    private int fAquireCount = 0;

    public CTextFileChange(String name, IFile file) {
        super(name, file);
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            this.fTranslationUnit = (ITranslationUnit)element;
            this.setTextType("c2");
        }
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        IDocument doc = super.acquireDocument(pm);
        if (++this.fAquireCount == 1 && this.fTranslationUnit != null && this.fWorkingCopy == null) {
            this.fWorkingCopy = this.fTranslationUnit.getWorkingCopy(null, DocumentAdapter.FACTORY);
            if (!this.fTranslationUnit.isOpen()) {
                this.fTranslationUnit.open(null);
            }
        }
        return doc;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.fWorkingCopy == null) {
            super.commit(document, pm);
        } else if (this.needsSaving()) {
            this.fWorkingCopy.commit(false, pm);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        super.releaseDocument(document, pm);
        if (--this.fAquireCount == 0 && this.fWorkingCopy != null) {
            this.fWorkingCopy.destroy();
            this.fWorkingCopy = null;
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        return new UndoCTextFileChange(this.getName(), this.getFile(), edit, stampToRestore, this.getSaveMode());
    }
}

