/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring.ui;

import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameRefactoring;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactoringPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CRenameRefactoringInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "RenameRefactoringPage";
    private static final String KEY_REFERENCES_INV = "references_inv";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_STRING = "string";
    private static final String KEY_INACTIVE = "inactive";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_WORKING_SET_NAME = "workingset";
    private static final String KEY_INCLUDE = "include";
    private static final String KEY_MACRO_DEFINITION = "macroDefinition";
    private static final String KEY_PREPROCESSOR = "preprocessor";
    private IDialogSettings fDialogSettings;
    private String fSearchString;
    private int fOptions;
    private int fForcePreviewOptions = 0;
    private int fEnableScopeOptions;
    private Text fNewName;
    private Button fWorkspace;
    private Button fDependent;
    private Button fInComment;
    private Button fInString;
    private Button fInInclude;
    private Button fInInactiveCode;
    private Button fReferences;
    private Button fSingle;
    private Button fWorkingSet;
    private Text fWorkingSetSpec;
    private Button fWorkingSetButton;
    private Button fInMacro;
    private Button fInPreprocessor;

    public CRenameRefactoringInputPage() {
        super(PAGE_NAME);
        String key = "CRenameRefactoringInputPage";
        IDialogSettings ds = CRefactoringPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = ds.getSection(key);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = ds.addNewSection(key);
        }
    }

    private boolean hasOption(int options) {
        return (this.fOptions & options) == options;
    }

    public void createControl(Composite parent) {
        CRenameProcessor processor = this.getRenameProcessor();
        this.fSearchString = processor.getArgument().getName();
        this.fOptions = processor.getAvailableOptions();
        this.fForcePreviewOptions = processor.getOptionsForcingPreview();
        this.fEnableScopeOptions = processor.getOptionsEnablingScope();
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        Composite group = top;
        Label l = new Label(group, 0);
        l.setText(Messages.getString("CRenameRefactoringInputPage.newIdentifier.label"));
        this.fNewName = new Text(group, 2048);
        this.fNewName.setText(this.fSearchString);
        this.fNewName.setLayoutData((Object)new GridData(768));
        this.fNewName.selectAll();
        boolean skippedLine = false;
        if (this.hasOption(1)) {
            this.skipLine(top);
            new Label(top, 0).setText(Messages.getString("CRenameRefactoringInputPage.label.scope"));
            skippedLine = true;
            group = new Composite(top, 0);
            GridData gd = new GridData(768);
            group.setLayoutData((Object)gd);
            gd.horizontalSpan = 2;
            group.setLayout((Layout)new GridLayout(3, false));
            this.fWorkspace = new Button(group, 16);
            this.fWorkspace.setText(Messages.getString("CRenameRefactoringInputPage.button.scope.workspace"));
            gd = new GridData();
            this.fWorkspace.setLayoutData((Object)gd);
            gd.horizontalSpan = 3;
            this.fDependent = new Button(group, 16);
            this.fDependent.setText(Messages.getString("CRenameRefactoringInputPage.button.scope.releatedprojects"));
            gd = new GridData();
            this.fDependent.setLayoutData((Object)gd);
            gd.horizontalSpan = 3;
            this.fSingle = new Button(group, 16);
            this.fSingle.setText(Messages.getString("CRenameRefactoringInputPage.button.singleProject"));
            gd = new GridData();
            this.fSingle.setLayoutData((Object)gd);
            gd.horizontalSpan = 3;
            this.fWorkingSet = new Button(group, 16);
            this.fWorkingSet.setText(Messages.getString("CRenameRefactoringInputPage.button.workingSet"));
            this.fWorkingSetSpec = new Text(group, 2056);
            this.fWorkingSetSpec.setLayoutData((Object)new GridData(768));
            this.fWorkingSetButton = new Button(group, 8);
            this.fWorkingSetButton.setText(Messages.getString("CRenameRefactoringInputPage.button.chooseWorkingSet"));
            this.setButtonLayoutData(this.fWorkingSetButton);
        }
        group = null;
        if (this.hasOption(128)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fReferences = new Button(group, 32);
            this.fReferences.setText(Messages.getString("CRenameRefactoringInputPage.update.label"));
        }
        if (this.hasOption(64)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInInactiveCode = new Button(group, 32);
            this.fInInactiveCode.setText(Messages.getString("CRenameRefactoringInputPage.button.inactiveCode"));
        }
        if (this.hasOption(2)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInComment = new Button(group, 32);
            this.fInComment.setText(Messages.getString("CRenameRefactoringInputPage.button.comments"));
        }
        if (this.hasOption(4)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInString = new Button(group, 32);
            this.fInString.setText(Messages.getString("CRenameRefactoringInputPage.button.strings"));
        }
        if (this.hasOption(16)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInMacro = new Button(group, 32);
            this.fInMacro.setText(Messages.getString("CRenameRefactoringInputPage.button.macrodefinitions"));
        }
        if (this.hasOption(8)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInInclude = new Button(group, 32);
            this.fInInclude.setText(Messages.getString("CRenameRefactoringInputPage.button.includes"));
        }
        if (this.hasOption(32)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInPreprocessor = new Button(group, 32);
            this.fInPreprocessor.setText(Messages.getString("CRenameRefactoringInputPage.button.preprocessor"));
        }
        Dialog.applyDialogFont((Control)top);
        this.hookSelectionListeners();
        this.readPreferences();
        this.onSelectOption();
        this.updatePageComplete();
    }

    private Composite createLabelAndGroup(Composite group, boolean skippedLine, Composite top) {
        if (group != null) {
            return group;
        }
        if (!skippedLine) {
            this.skipLine(top);
        }
        new Label(top, 0).setText(Messages.getString("CRenameRefactoringInputPage.label.updateWithin"));
        group = new Composite(top, 0);
        GridData gd = new GridData();
        group.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(1, true));
        return group;
    }

    private void skipLine(Composite top) {
        new Label(top, 0);
        new Label(top, 0);
    }

    private void hookSelectionListeners() {
        this.fNewName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                CRenameRefactoringInputPage.this.onKeyReleaseInNameField();
            }
        });
        this.registerScopeListener(this.fWorkspace, 2);
        this.registerScopeListener(this.fDependent, 3);
        this.registerScopeListener(this.fSingle, 4);
        this.registerScopeListener(this.fWorkingSet, 5);
        if (this.fWorkingSetButton != null) {
            this.fWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CRenameRefactoringInputPage.this.onSelectWorkingSet();
                }
            });
        }
        SelectionAdapter listenOption = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CRenameRefactoringInputPage.this.onSelectOption();
            }
        };
        this.registerOptionListener(this.fReferences, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInComment, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInInactiveCode, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInInclude, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInMacro, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInString, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInPreprocessor, (SelectionListener)listenOption);
    }

    private void registerScopeListener(Button button, final int scope) {
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CRenameRefactoringInputPage.this.onSelectedScope(scope);
                }
            });
        }
    }

    private void registerOptionListener(Button button, SelectionListener listenOption) {
        if (button != null) {
            button.addSelectionListener(listenOption);
        }
    }

    protected void onSelectedScope(int scope) {
        this.getRenameProcessor().setScope(scope);
        this.updateEnablement();
    }

    private void onSelectOption() {
        int selectedOptions = this.computeSelectedOptions();
        boolean forcePreview = this.fForcePreviewOptions == -1 || (selectedOptions & this.fForcePreviewOptions) != 0;
        this.getRenameProcessor().setSelectedOptions(selectedOptions);
        this.getRefactoringWizard().setForcePreviewReview(forcePreview);
        this.updateEnablement();
    }

    protected void onKeyReleaseInNameField() {
        this.getRenameProcessor().setReplacementText(this.fNewName.getText());
        this.updatePageComplete();
    }

    public void dispose() {
        this.storePreferences();
        super.dispose();
    }

    private void readPreferences() {
        CRenameProcessor processor = this.getRenameProcessor();
        if (this.fWorkspace != null) {
            int choice;
            try {
                choice = this.fDialogSettings.getInt(KEY_SCOPE);
            }
            catch (Exception exception) {
                choice = 3;
            }
            switch (choice) {
                case 2: {
                    this.fWorkspace.setSelection(true);
                    break;
                }
                case 4: {
                    this.fSingle.setSelection(true);
                    break;
                }
                case 5: {
                    this.fWorkingSet.setSelection(true);
                    break;
                }
                default: {
                    choice = 3;
                    this.fDependent.setSelection(true);
                }
            }
            processor.setScope(choice);
            String workingSet = this.checkWorkingSet(this.fDialogSettings.get(KEY_WORKING_SET_NAME));
            this.fWorkingSetSpec.setText(workingSet);
            processor.setWorkingSet(workingSet);
        }
        if (this.fReferences != null) {
            boolean val = !this.fDialogSettings.getBoolean(KEY_REFERENCES_INV);
            this.fReferences.setSelection(val);
        }
        this.initOption(this.fInComment, KEY_COMMENT);
        this.initOption(this.fInString, KEY_STRING);
        this.initOption(this.fInInclude, KEY_INCLUDE);
        this.initOption(this.fInMacro, KEY_MACRO_DEFINITION);
        this.initOption(this.fInPreprocessor, KEY_PREPROCESSOR);
        this.initOption(this.fInInactiveCode, KEY_INACTIVE);
    }

    private int computeSelectedOptions() {
        int options = 0;
        options |= this.computeOption(this.fReferences, 128);
        options |= this.computeOption(this.fInComment, 2);
        options |= this.computeOption(this.fInString, 4);
        options |= this.computeOption(this.fInInclude, 8);
        options |= this.computeOption(this.fInPreprocessor, 32);
        options |= this.computeOption(this.fInMacro, 16);
        return options |= this.computeOption(this.fInInactiveCode, 64);
    }

    private int computeOption(Button button, int option) {
        if (button != null && button.getSelection()) {
            return option;
        }
        return 0;
    }

    private void initOption(Button button, String key) {
        boolean val = false;
        if (button != null) {
            val = this.fDialogSettings.getBoolean(key);
            button.setSelection(val);
        }
    }

    private String checkWorkingSet(String ws) {
        IWorkingSetManager wsManager;
        if (ws != null && ws.length() > 0 && (wsManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(ws) != null) {
            return ws;
        }
        return "";
    }

    private void storePreferences() {
        if (this.fWorkspace != null) {
            int choice = 3;
            if (this.fWorkspace.getSelection()) {
                choice = 2;
            } else if (this.fSingle.getSelection()) {
                choice = 4;
            } else if (this.fWorkingSet.getSelection()) {
                choice = 5;
            }
            this.fDialogSettings.put(KEY_SCOPE, choice);
            this.fDialogSettings.put(KEY_WORKING_SET_NAME, this.fWorkingSetSpec.getText());
        }
        if (this.fReferences != null) {
            this.fDialogSettings.put(KEY_REFERENCES_INV, !this.fReferences.getSelection());
        }
        if (this.fInComment != null) {
            this.fDialogSettings.put(KEY_COMMENT, this.fInComment.getSelection());
        }
        if (this.fInString != null) {
            this.fDialogSettings.put(KEY_STRING, this.fInString.getSelection());
        }
        if (this.fInInclude != null) {
            this.fDialogSettings.put(KEY_INCLUDE, this.fInInclude.getSelection());
        }
        if (this.fInPreprocessor != null) {
            this.fDialogSettings.put(KEY_PREPROCESSOR, this.fInPreprocessor.getSelection());
        }
        if (this.fInMacro != null) {
            this.fDialogSettings.put(KEY_MACRO_DEFINITION, this.fInMacro.getSelection());
        }
        if (this.fInInactiveCode != null) {
            this.fDialogSettings.put(KEY_INACTIVE, this.fInInactiveCode.getSelection());
        }
    }

    protected void onSelectWorkingSet() {
        CRenameProcessor processor = this.getRenameProcessor();
        String wsName = this.checkWorkingSet(this.fWorkingSetSpec.getText());
        IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dlg = wsManager.createWorkingSetSelectionDialog(this.getShell(), false);
        IWorkingSet currentWorkingSet = wsManager.getWorkingSet(wsName);
        if (currentWorkingSet != null) {
            dlg.setSelection(new IWorkingSet[]{currentWorkingSet});
        }
        IWorkingSet ws = null;
        if (dlg.open() == 0) {
            IWorkingSet[] wsa = dlg.getSelection();
            if (wsa != null && wsa.length > 0) {
                ws = wsa[0];
            }
            if (ws != null) {
                this.fWorkspace.setSelection(false);
                this.fDependent.setSelection(false);
                this.fSingle.setSelection(false);
                this.fWorkingSet.setSelection(true);
                processor.setScope(5);
                wsName = ws.getName();
            }
        }
        this.fWorkingSetSpec.setText(wsName);
        processor.setWorkingSet(wsName);
        this.updateEnablement();
    }

    protected void updatePageComplete() {
        String txt = this.fNewName.getText();
        if (txt.length() == 0 || txt.equals(this.fSearchString)) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
        } else if (!this.isValidIdentifier(txt)) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("CRenameRefactoringInputPage.errorInvalidIdentifier"), (Object)txt));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isValidIdentifier(String txt) {
        if (txt.length() < 1) {
            return false;
        }
        chars = txt.toCharArray();
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            switch (c) {
                case '?': {
                    if (i + 2 >= chars.length) {
                        return false;
                    }
                    if (chars[++i] != '?') {
                        return false;
                    }
                    if (chars[++i] != '/') {
                        return false;
                    }
                }
                case '\\': {
                    if (++i >= chars.length) {
                        return false;
                    }
                    hexdigits = 0;
                    switch (chars[i]) {
                        case 'u': {
                            hexdigits = 4;
                            ** GOTO lbl34
                        }
                        case 'U': {
                            hexdigits = 8;
                            if (true) ** GOTO lbl34
                        }
                        default: {
                            return false;
                        }
                    }
                    do {
                        if (++i >= chars.length) {
                            return false;
                        }
                        if (!this.isHexDigit(chars[i])) {
                            return false;
                        }
                        --hexdigits;
lbl34:
                        // 3 sources

                    } while (hexdigits > 0);
                    break;
                }
                case '_': {
                    break;
                }
                default: {
                    if (!(i == 0 ? Character.isLetter(c) == false : Character.isLetterOrDigit(c) == false)) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    protected void updateEnablement() {
        boolean enable;
        boolean bl = enable = this.fEnableScopeOptions == -1 || (this.computeSelectedOptions() & this.fEnableScopeOptions) != 0;
        if (this.fWorkspace != null) {
            this.fWorkspace.setEnabled(enable);
            this.fDependent.setEnabled(enable);
            this.fSingle.setEnabled(enable);
            boolean enableSpec = false;
            this.fWorkingSet.setEnabled(enable);
            if (enable && this.fWorkingSet.getSelection()) {
                enableSpec = true;
            }
            this.fWorkingSetSpec.setEnabled(enableSpec);
            this.fWorkingSetButton.setEnabled(enable);
        }
    }

    private CRenameProcessor getRenameProcessor() {
        return (CRenameProcessor)((CRenameRefactoring)this.getRefactoring()).getProcessor();
    }
}

