/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.actions.BlockCommentAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoveBlockCommentAction
extends BlockCommentAction {
    public RemoveBlockCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void runInternal(ITextSelection selection, IDocumentExtension3 docExtension, BlockCommentAction.Edit.EditFactory factory) throws BadPartitioningException, BadLocationException {
        LinkedList<BlockCommentAction.Edit> edits = new LinkedList<BlockCommentAction.Edit>();
        int tokenLength = this.getCommentStart().length();
        int offset = selection.getOffset();
        int endOffset = offset + selection.getLength();
        ITypedRegion partition = docExtension.getPartition("___c_partitioning", offset, false);
        int partOffset = partition.getOffset();
        int partEndOffset = partOffset + partition.getLength();
        while (partEndOffset < endOffset) {
            if (partition.getType() == "__c_multiline_comment") {
                edits.add(factory.createEdit(partOffset, tokenLength, ""));
                edits.add(factory.createEdit(partEndOffset - tokenLength, tokenLength, ""));
            }
            partition = docExtension.getPartition("___c_partitioning", partEndOffset, false);
            partOffset = partition.getOffset();
            partEndOffset = partOffset + partition.getLength();
        }
        if (partition.getType() == "__c_multiline_comment") {
            edits.add(factory.createEdit(partOffset, tokenLength, ""));
            edits.add(factory.createEdit(partEndOffset - tokenLength, tokenLength, ""));
        }
        this.executeEdits(edits);
    }

    protected boolean isValidSelection(ITextSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getLength() > 0;
    }
}

