/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludesOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;
    private IRequiredInclude[] fRequiredIncludes;
    private String[] fUsings;

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = editor;
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.add_includes_on_selection_action_context");
    }

    private void addInclude(ITranslationUnit tu) {
        AddIncludesOperation op = new AddIncludesOperation(tu, this.fRequiredIncludes, this.fUsings, false);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(op), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected ITranslationUnit getTranslationUnit() {
        IWorkingCopy unit = null;
        if (this.fEditor != null) {
            IEditorInput editorInput = this.fEditor.getEditorInput();
            unit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return unit;
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        IIndex index;
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu == null) {
            return;
        }
        try {
            index = CCorePlugin.getIndexManager().getIndex(tu.getCProject(), 1);
            index.acquireReadLock();
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            if (tu != null) {
                this.extractIncludes(this.fEditor, index);
                this.addInclude(tu);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            index.releaseReadLock();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        index.releaseReadLock();
        this.fUsings = null;
        this.fRequiredIncludes = null;
    }

    private void extractIncludes(ITextEditor editor, IIndex index) {
        if (editor == null) {
            return;
        }
        ISelection s = editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (s.isEmpty() || !(s instanceof ITextSelection) || doc == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)s;
        try {
            IRegion region = CWordFinder.findWord(doc, selection.getOffset());
            if (region == null || region.getLength() == 0) {
                return;
            }
            String name = doc.get(region.getOffset(), region.getLength());
            if (name.length() == 0) {
                return;
            }
            IFunctionSummary fs = this.findContribution(name);
            if (fs != null) {
                this.fRequiredIncludes = fs.getIncludes();
                String ns = fs.getNamespace();
                if (ns != null && ns.length() > 0) {
                    this.fUsings = new String[]{fs.getNamespace()};
                }
            }
            try {
                IIndexBinding binding;
                Pattern pattern = Pattern.compile(name);
                IndexFilter filter = new IndexFilter(){};
                IIndexBinding[] bindings = index.findBindings(pattern, false, filter, (IProgressMonitor)new NullProgressMonitor());
                ArrayList<DisplayName> pdomNames = new ArrayList<DisplayName>();
                int i = 0;
                while (i < bindings.length) {
                    binding = bindings[i];
                    IIndexName[] defs = null;
                    if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
                        defs = index.findDefinitions((IBinding)binding);
                    } else if (binding instanceof ITypedef || binding instanceof IFunction) {
                        defs = index.findDeclarations((IBinding)binding);
                    }
                    if (defs != null) {
                        int j = 0;
                        while (j < defs.length) {
                            pdomNames.add(new DisplayName(defs[j], binding));
                            ++j;
                        }
                    }
                    ++i;
                }
                if (pdomNames.size() > 1) {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new TypeInfoLabelProvider(1));
                    dialog.setElements(pdomNames.toArray());
                    dialog.setTitle(CEditorMessages.getString("AddIncludeOnSelection.label"));
                    dialog.setMessage(CEditorMessages.getString("AddIncludeOnSelection.description"));
                    if (dialog.open() == 0) {
                        Object[] selects = dialog.getResult();
                        this.fRequiredIncludes = new IRequiredInclude[selects.length];
                        ArrayList<String> usings = new ArrayList<String>(selects.length);
                        int i2 = 0;
                        while (i2 < this.fRequiredIncludes.length) {
                            IRequiredInclude include = this.getRequiredInclude(((DisplayName)selects[i2]).getName().getFileLocation().getFileName(), this.getTranslationUnit());
                            if (include != null) {
                                QualifiedTypeName qualifiedName;
                                String qualifiedEnclosingName;
                                this.fRequiredIncludes[i2] = include;
                                IIndexBinding binding2 = ((DisplayName)selects[i2]).getBinding();
                                if (binding2 instanceof ICPPBinding && !(qualifiedEnclosingName = new QualifiedTypeName((qualifiedName = new QualifiedTypeName(AddIncludeOnSelectionAction.getBindingQualifiedName(binding2))).getEnclosingNames()).getFullyQualifiedName()).equals("")) {
                                    usings.add(qualifiedEnclosingName);
                                }
                            }
                            ++i2;
                        }
                        if (usings.size() > 0) {
                            this.fUsings = new String[usings.size()];
                            i2 = 0;
                            while (i2 < usings.size()) {
                                this.fUsings[i2] = (String)usings.get(i2);
                                ++i2;
                            }
                        }
                    }
                } else if (pdomNames.size() == 1) {
                    QualifiedTypeName qualifiedName;
                    String qualifiedEnclosingName;
                    String fileName = ((DisplayName)pdomNames.get(0)).getName().getFileLocation().getFileName();
                    this.fRequiredIncludes = new IRequiredInclude[]{this.getRequiredInclude(fileName, this.getTranslationUnit())};
                    binding = ((DisplayName)pdomNames.get(0)).getBinding();
                    if (binding instanceof ICPPBinding && !(qualifiedEnclosingName = new QualifiedTypeName((qualifiedName = new QualifiedTypeName(AddIncludeOnSelectionAction.getBindingQualifiedName(binding))).getEnclosingNames()).getFullyQualifiedName()).equals("")) {
                        this.fUsings = new String[]{qualifiedEnclosingName};
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (this.fRequiredIncludes == null) {
                // empty if block
            }
            if (this.fRequiredIncludes == null) {
                // empty if block
            }
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + e.getMessage()));
        }
    }

    private IFunctionSummary findContribution(final String name) {
        final IFunctionSummary[] fs = new IFunctionSummary[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ICHelpInvocationContext context = new ICHelpInvocationContext(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IProject getProject() {
                        ITranslationUnit u = this.getTranslationUnit();
                        if (u != null) {
                            return u.getCProject().getProject();
                        }
                        return null;
                    }

                    public ITranslationUnit getTranslationUnit() {
                        return 2.access$0(this.this$1).getTranslationUnit();
                    }
                };
                fs[0] = CHelpProviderManager.getDefault().getFunctionInfo(context, name);
            }

            static /* synthetic */ AddIncludeOnSelectionAction access$0(2 var0) {
                return var0.AddIncludeOnSelectionAction.this;
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), CEditorMessages.getString("AddIncludeOnSelection.error.message1"), null);
        }
        catch (InterruptedException interruptedException) {}
        return fs[0];
    }

    public void setContentEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void update() {
        this.setEnabled(this.getTranslationUnit() != null);
    }

    private IRequiredInclude getRequiredInclude(String path, ITranslationUnit tu) {
        if (path != null) {
            Path typeLocation = new Path(path);
            IProject project = tu.getCProject().getProject();
            IPath projectLocation = project.getLocation();
            IPath workspaceLocation = project.getWorkspace().getRoot().getLocation();
            IPath headerLocation = tu.getResource().getLocation();
            boolean isSystemIncludePath = false;
            IPath includePath = AddIncludeOnSelectionAction.makeRelativePathToProjectIncludes((IPath)typeLocation, tu);
            if (includePath != null && !projectLocation.isPrefixOf((IPath)typeLocation)) {
                isSystemIncludePath = true;
            } else if (projectLocation.isPrefixOf((IPath)typeLocation) && projectLocation.isPrefixOf(headerLocation)) {
                includePath = PathUtil.makeRelativePath((IPath)typeLocation, (IPath)headerLocation.removeLastSegments(1));
            } else if (workspaceLocation.isPrefixOf((IPath)typeLocation)) {
                includePath = PathUtil.makeRelativePath((IPath)typeLocation, (IPath)projectLocation);
            }
            if (includePath == null) {
                includePath = typeLocation;
            }
            return new RequiredIncludes(includePath.toString(), isSystemIncludePath);
        }
        return null;
    }

    private static IPath makeRelativePathToProjectIncludes(IPath fullPath, ITranslationUnit tu) {
        IScannerInfo info;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(tu.getCProject().getProject());
        if (provider != null && (info = provider.getScannerInformation(tu.getResource())) != null) {
            return PathUtil.makeRelativePathToIncludes((IPath)fullPath, (String[])info.getIncludePaths());
        }
        return null;
    }

    private static String getBindingQualifiedName(IIndexBinding binding) throws CoreException {
        StringBuffer buf = new StringBuffer();
        String[] qname = binding.getQualifiedName();
        int i = 0;
        while (i < qname.length) {
            if (i > 0) {
                buf.append("::");
            }
            buf.append(qname[i]);
            ++i;
        }
        return buf.toString();
    }

    private static class DisplayName {
        private IIndexName name;
        private IIndexBinding binding;

        public DisplayName(IIndexName name, IIndexBinding binding) {
            this.name = name;
            this.binding = binding;
        }

        public String toString() {
            try {
                if (this.binding != null) {
                    return String.valueOf(AddIncludeOnSelectionAction.getBindingQualifiedName(this.binding)) + " - " + this.name.getFileLocation().getFileName();
                }
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return null;
            }
        }

        public IIndexName getName() {
            return this.name;
        }

        public IIndexBinding getBinding() {
            return this.binding;
        }
    }

    class RequiredIncludes
    implements IRequiredInclude {
        String name;
        boolean isStandard;

        RequiredIncludes(String n) {
            this.name = n;
            this.isStandard = true;
        }

        RequiredIncludes(String n, boolean isStandard) {
            this.name = n;
            this.isStandard = isStandard;
        }

        public String getIncludeName() {
            return this.name;
        }

        public boolean isStandard() {
            return this.isStandard;
        }
    }
}

