/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlink;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public CElementHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IIndex index;
        if (region == null) return null;
        if (canShowMultipleHyperlinks) return null;
        if (!(this.fTextEditor instanceof CEditor)) {
            return null;
        }
        CEditor editor = (CEditor)this.fTextEditor;
        int offset = region.getOffset();
        final IAction openAction = editor.getAction("OpenDeclarations");
        if (openAction == null) {
            return null;
        }
        final ITextSelection selection = OpenDeclarationsAction.selectWord(offset, (ITextEditor)editor);
        if (selection == null) {
            return null;
        }
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (workingCopy == null) {
            return null;
        }
        try {
            index = CCorePlugin.getIndexManager().getIndex(workingCopy.getCProject(), 3);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        final IHyperlink[] result = new IHyperlink[1];
        try {
            IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_YES, null, new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                    IASTName[] selectedNames = lang.getSelectedNames(ast, selection.getOffset(), selection.getLength());
                    Object linkRegion = selectedNames.length > 0 && selectedNames[0] != null ? new Region(selection.getOffset(), selection.getLength()) : CElementHyperlinkDetector.this.matchIncludeStatement(ast, selection);
                    if (linkRegion != null) {
                        result[0] = new CElementHyperlink((IRegion)linkRegion, openAction);
                    }
                    return Status.OK_STATUS;
                }
            });
            if (!status.isOK()) {
                CUIPlugin.getDefault().log(status);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            index.releaseReadLock();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        index.releaseReadLock();
        if (result[0] == null) {
            return null;
        }
        IHyperlink[] iHyperlinkArray = result;
        return iHyperlinkArray;
    }

    private IRegion matchIncludeStatement(IASTTranslationUnit ast, ITextSelection selection) {
        IASTPreprocessorStatement[] preprocs = ast.getAllPreprocessorStatements();
        int i = 0;
        while (i < preprocs.length) {
            IASTFileLocation loc;
            if (preprocs[i] instanceof IASTPreprocessorIncludeStatement && (loc = preprocs[i].getFileLocation()) != null && loc.getFileName().equals(ast.getFilePath()) && loc.getNodeOffset() < selection.getOffset() && loc.getNodeOffset() + loc.getNodeLength() > selection.getOffset()) {
                return new Region(loc.getNodeOffset(), loc.getNodeLength());
            }
            ++i;
        }
        return null;
    }
}

