/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.LineBackgroundPainter;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.swt.widgets.Display;

public class InactiveCodeHighlighting
implements ICReconcilingListener,
ITextInputListener {
    private LineBackgroundPainter fLineBackgroundPainter;
    private String fHighlightKey;
    private ITranslationUnit fTranslationUnit;
    private Job fUpdateJob;
    private Object fJobLock = new Object();
    private CEditor fEditor;
    private List fInactiveCodePositions = Collections.EMPTY_LIST;
    private IDocument fDocument;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.editor.InactiveCodeHighlighting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public InactiveCodeHighlighting(String highlightKey) {
        this.fHighlightKey = highlightKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new Job(CEditorMessages.getString("InactiveCodeHighlighting_job")){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus result = Status.OK_STATUS;
                        if (InactiveCodeHighlighting.this.fTranslationUnit != null) {
                            ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                            result = astProvider.runOnAST((ICElement)InactiveCodeHighlighting.this.fTranslationUnit, ASTProvider.WAIT_YES, monitor, new ASTCache.ASTRunnable(this, monitor){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IProgressMonitor val$monitor;
                                {
                                    this.this$1 = var1_1;
                                    this.val$monitor = iProgressMonitor;
                                }

                                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                    1.access$0(this.this$1).reconciled(ast, true, this.val$monitor);
                                    return Status.OK_STATUS;
                                }
                            });
                        }
                        if (monitor.isCanceled()) {
                            result = Status.CANCEL_STATUS;
                        }
                        return result;
                    }

                    static /* synthetic */ InactiveCodeHighlighting access$0(1 var0) {
                        return var0.InactiveCodeHighlighting.this;
                    }
                };
                this.fUpdateJob.setPriority(50);
            }
            if (this.fUpdateJob.getState() == 0) {
                this.fUpdateJob.schedule();
            }
        }
    }

    public void install(CEditor editor, LineBackgroundPainter lineBackgroundPainter) {
        if (!$assertionsDisabled && this.fEditor != null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || editor != null && lineBackgroundPainter != null)) {
            throw new AssertionError();
        }
        this.fEditor = editor;
        this.fLineBackgroundPainter = lineBackgroundPainter;
        ICElement cElement = this.fEditor.getInputCElement();
        this.fTranslationUnit = cElement instanceof ITranslationUnit ? (ITranslationUnit)cElement : null;
        this.fDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.fEditor.getViewer().addTextInputListener((ITextInputListener)this);
        this.fEditor.addReconcileListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob != null && this.fUpdateJob.getState() == 4) {
                this.fUpdateJob.cancel();
            }
        }
        if (this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.EMPTY_LIST;
            this.fLineBackgroundPainter = null;
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            if (this.fEditor.getViewer() != null) {
                this.fEditor.getViewer().removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
            this.fTranslationUnit = null;
            this.fDocument = null;
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return;
        }
        final List newInactiveCodePositions = this.collectInactiveCodePositions(ast);
        Runnable updater = new Runnable(){

            public void run() {
                if (InactiveCodeHighlighting.this.fEditor != null && InactiveCodeHighlighting.this.fLineBackgroundPainter != null && !InactiveCodeHighlighting.this.fLineBackgroundPainter.isDisposed()) {
                    InactiveCodeHighlighting.this.fLineBackgroundPainter.replaceHighlightPositions(InactiveCodeHighlighting.this.fInactiveCodePositions, newInactiveCodePositions);
                    InactiveCodeHighlighting.this.fInactiveCodePositions = newInactiveCodePositions;
                }
            }
        };
        if (this.fEditor != null) {
            Display.getDefault().asyncExec(updater);
        }
    }

    private List collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        if (translationUnit == null) {
            return Collections.EMPTY_LIST;
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HighlightPosition> positions = new ArrayList<HighlightPosition>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] preprocStmts = translationUnit.getAllPreprocessorStatements();
        int i = 0;
        while (i < preprocStmts.length) {
            IASTNodeLocation[] nodeLocations;
            IASTPreprocessorStatement statement = preprocStmts[i];
            if (fileName.equals(statement.getContainingFilename()) && (nodeLocations = statement.getNodeLocations()).length == 1) {
                int inactiveCodeEnd;
                IASTNodeLocation stmtLocation = nodeLocations[0];
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = stmtLocation.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = stmtLocation.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = stmtLocation.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = stmtLocation.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = stmtLocation.getNodeOffset();
                        positions.add(this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, this.fHighlightKey));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = stmtLocation.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = stmtLocation.getNodeOffset();
                        positions.add(this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, this.fHighlightKey));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = stmtLocation.getNodeOffset() + stmtLocation.getNodeLength();
                            positions.add(this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, true, this.fHighlightKey));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++i;
        }
        return positions;
    }

    private HighlightPosition createHighlightPosition(int startOffset, int endOffset, boolean inclusive, String key) {
        IDocument document = this.fDocument;
        try {
            if (document != null) {
                int start = document.getLineOfOffset(startOffset);
                int end = document.getLineOfOffset(endOffset);
                startOffset = document.getLineOffset(start);
                if (!inclusive) {
                    endOffset = document.getLineOffset(end);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new HighlightPosition(startOffset, endOffset - startOffset, key);
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fEditor != null && this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.EMPTY_LIST;
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.fDocument = newInput;
    }

    private static class HighlightPosition
    extends TypedPosition
    implements IRegion {
        public HighlightPosition(int offset, int length, String type) {
            super(offset, length, type);
        }

        public HighlightPosition(IRegion region, String type) {
            super(region.getOffset(), region.getLength(), type);
        }
    }
}

