/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    private static final RGB RGB_BLACK = new RGB(0, 0, 0);
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclaration";
    public static final String STATIC_METHOD_INVOCATION = "staticMethod";
    public static final String FUNCTION_DECLARATION = "functionDeclaration";
    public static final String FUNCTION = "function";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String GLOBAL_VARIABLE = "globalVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String TEMPLATE_PARAMETER = "templateParameter";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String MACRO_REFERENCE = "macroSubstitution";
    public static final String MACRO_DEFINITION = "macroDefinition";
    public static final String TYPEDEF = "typedef";
    public static final String NAMESPACE = "namespace";
    public static final String LABEL = "label";
    public static final String ENUMERATOR = "enumerator";
    public static final String PROBLEM = "problem";
    public static final String EXTERNAL_SDK = "externalSDK";
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/SemanticHighlighting"));
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new MacroReferenceHighlighting(), new ProblemHighlighting(), new ExternalSDKHighlighting(), new ClassHighlighting(), new StaticFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new GlobalVariableHighlighting(), new TemplateParameterHighlighting(), new MethodHighlighting(), new EnumHighlighting(), new MacroDefinitionHighlighting(), new FunctionDeclarationHighlighting(), new FunctionHighlighting(), new TypedefHighlighting(), new NamespaceHighlighting(), new LabelHighlighting(), new EnumeratorHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("semanticHighlighting.enabled", true);
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), DEBUG || semanticHighlighting.isEnabledByDefault());
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), (RGB)semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), DEBUG || semanticHighlighting.isUnderlineByDefault());
            ++i;
        }
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        if (event.getProperty().equals("semanticHighlighting.enabled")) {
            return true;
        }
        String relevantKey = null;
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        if (!store.getBoolean("semanticHighlighting.enabled")) {
            return false;
        }
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private SemanticHighlightings() {
    }

    private static final class ClassHighlighting
    extends SemanticHighlighting {
        private ClassHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.CLASS;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 80, 50);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_classes");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            if (node instanceof ICPPASTQualifiedName || node instanceof ICPPASTTemplateId) {
                return false;
            }
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPClassType;
        }
    }

    private static final class EnumHighlighting
    extends SemanticHighlighting {
        private EnumHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.ENUM;
        }

        public RGB getDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_enums");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof IEnumeration;
        }
    }

    private static final class EnumeratorHighlighting
    extends SemanticHighlighting {
        private EnumeratorHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.ENUMERATOR;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_enumerator");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IEnumerator) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ExternalSDKHighlighting
    extends SemanticHighlighting {
        private ExternalSDKHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.EXTERNAL_SDK;
        }

        public RGB getDefaultTextColor() {
            return new RGB(100, 40, 128);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isStrikethroughByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_externalSDK");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IBinding binding;
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (name.isReference() && (binding = token.getBinding()) instanceof IIndexBinding) {
                    IIndex index = token.getRoot().getIndex();
                    return this.isExternalSDKReference((IIndexBinding)binding, index);
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isExternalSDKReference(IIndexBinding binding, IIndex index) {
            if (!(binding instanceof IFunction)) return false;
            try {
                if (binding.isFileLocal()) {
                    return false;
                }
                IIndexName[] decls = index.findDeclarations((IBinding)binding);
                int i = 0;
                while (true) {
                    if (i >= decls.length) {
                        if (decls.length == 0) return false;
                        return true;
                    }
                    IIndexFile indexFile = decls[i].getFile();
                    if (indexFile != null && indexFile.getLocation().getFullPath() != null) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (CoreException exc) {
                CUIPlugin.getDefault().log(exc.getStatus());
                return false;
            }
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.FIELD;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_field");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class FunctionDeclarationHighlighting
    extends SemanticHighlighting {
        private FunctionDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.FUNCTION_DECLARATION;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_functionDeclaration");
        }

        public boolean consumes(SemanticToken token) {
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration()) {
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
                if (binding instanceof IProblemBinding) {
                    if (name instanceof ICPPASTQualifiedName) {
                        return false;
                    }
                    node = name.getParent();
                    while (node instanceof IASTName) {
                        node = node.getParent();
                    }
                    if (node instanceof IASTFunctionDeclarator) {
                        while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier)) {
                            node = node.getParent();
                        }
                        return !(node instanceof ICPPASTCompositeTypeSpecifier);
                    }
                }
            }
            return false;
        }
    }

    private static final class FunctionHighlighting
    extends SemanticHighlighting {
        private FunctionHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.FUNCTION;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_function");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class GlobalVariableHighlighting
    extends SemanticHighlighting {
        private GlobalVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.GLOBAL_VARIABLE;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_globalVariable");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                    try {
                        IScope scope = binding.getScope();
                        if (!LocalVariableHighlighting.isLocalScope(scope)) {
                            return true;
                        }
                    }
                    catch (DOMException exc) {
                        CUIPlugin.getDefault().log(exc);
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class LabelHighlighting
    extends SemanticHighlighting {
        private LabelHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LABEL;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_label");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ILabel;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(128, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_localVariableDeclaration");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isDeclaration() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException exc) {
                    CUIPlugin.getDefault().log(exc);
                }
                catch (Error error) {}
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_localVariable");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTName name;
            IASTNode node = token.getNode();
            if (node instanceof IASTName && (name = (IASTName)node).isReference() && (binding = token.getBinding()) instanceof IVariable && !(binding instanceof IField) && !(binding instanceof IParameter) && !(binding instanceof IProblemBinding)) {
                try {
                    IScope scope = binding.getScope();
                    if (LocalVariableHighlighting.isLocalScope(scope)) {
                        return true;
                    }
                }
                catch (DOMException exc) {
                    CUIPlugin.getDefault().log(exc);
                }
                catch (Error error) {}
            }
            return false;
        }

        public static boolean isLocalScope(IScope scope) {
            while (scope != null) {
                if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                    return true;
                }
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {
                    scope = null;
                }
            }
            return false;
        }
    }

    private static final class MacroDefinitionHighlighting
    extends SemanticHighlighting {
        private MacroDefinitionHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.MACRO_DEFINITION;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_macroDefintion");
        }

        public boolean consumes(SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && !(name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MacroReferenceHighlighting
    extends SemanticHighlighting {
        private MacroReferenceHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.MACRO_REFERENCE;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_macroSubstitution");
        }

        public boolean consumes(SemanticToken token) {
            IASTName name;
            IBinding binding = token.getBinding();
            return binding instanceof IMacroBinding && (name = (IASTName)token.getNode()).isReference();
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_methodDeclaration");
        }

        /*
         * Unable to fully structure code
         */
        public boolean consumes(SemanticToken token) {
            block7: {
                node = token.getNode();
                if (!(node instanceof IASTName) || (name = (IASTName)node).isReference()) break block7;
                binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
                if (!(binding instanceof IProblemBinding)) break block7;
                node = name.getParent();
                while (node instanceof IASTName) {
                    node = node.getParent();
                }
                if (!(node instanceof ICPPASTFunctionDeclarator)) break block7;
                if (!(name instanceof ICPPASTQualifiedName)) ** GOTO lbl18
                qName = (ICPPASTQualifiedName)name;
                names = qName.getNames();
                if (names.length <= 1 || !(names[names.length - 2].getBinding() instanceof ICPPClassType)) break block7;
                return true;
lbl-1000:
                // 1 sources

                {
                    node = node.getParent();
lbl18:
                    // 2 sources

                    ** while (node != token.getRoot() && !(node.getParent() instanceof IASTDeclSpecifier))
                }
lbl19:
                // 1 sources

                if (node instanceof ICPPASTCompositeTypeSpecifier) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_method");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    return true;
                }
            }
            return false;
        }
    }

    private static final class NamespaceHighlighting
    extends SemanticHighlighting {
        private NamespaceHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.NAMESPACE;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_namespace");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof ICPPNamespace;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_parameterVariable");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding instanceof IParameter;
        }
    }

    private static final class ProblemHighlighting
    extends SemanticHighlighting {
        private ProblemHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.PROBLEM;
        }

        public RGB getDefaultTextColor() {
            return new RGB(224, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isStrikethroughByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_problem");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTProblem) {
                return true;
            }
            IBinding binding = token.getBinding();
            return binding instanceof IProblemBinding;
        }
    }

    private static final class StaticFieldHighlighting
    extends SemanticHighlighting {
        private StaticFieldHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FIELD;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_staticField");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName && name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof IField && !(binding instanceof IProblemBinding)) {
                    try {
                        return ((IField)binding).isStatic();
                    }
                    catch (DOMException exc) {
                        CUIPlugin.getDefault().log(exc);
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class StaticMethodInvocationHighlighting
    extends SemanticHighlighting {
        private StaticMethodInvocationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_METHOD_INVOCATION;
        }

        public RGB getDefaultTextColor() {
            return RGB_BLACK;
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_staticMethodInvocation");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                if (!name.isReference()) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ICPPMethod) {
                    try {
                        return ((ICPPMethod)binding).isStatic();
                    }
                    catch (DOMException exc) {
                        CUIPlugin.getDefault().log(exc);
                    }
                    catch (Error error) {}
                }
            }
            return false;
        }
    }

    private static final class TemplateParameterHighlighting
    extends SemanticHighlighting {
        private TemplateParameterHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.TEMPLATE_PARAMETER;
        }

        public RGB getDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_templateParameter");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding;
            IASTNode node = token.getNode();
            return node instanceof IASTName && (binding = token.getBinding()) instanceof ICPPTemplateParameter;
        }
    }

    private static final class TypedefHighlighting
    extends SemanticHighlighting {
        private TypedefHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.TYPEDEF;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 80, 50);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return CEditorMessages.getString("SemanticHighlighting_typeDef");
        }

        public boolean consumes(SemanticToken token) {
            IASTNode node = token.getNode();
            if (node instanceof IASTName) {
                IASTName name = (IASTName)node;
                if (name instanceof ICPPASTQualifiedName) {
                    return false;
                }
                IBinding binding = token.getBinding();
                if (binding instanceof ITypedef) {
                    return true;
                }
            }
            return false;
        }
    }
}

