/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IBViewPart;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class IBHistoryListAction
extends Action {
    private IBViewPart fView;

    public IBHistoryListAction(IBViewPart view) {
        this.fView = view;
        this.setText(IBMessages.IBHistoryListAction_label);
    }

    public void run() {
        ITranslationUnit[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(this.fView.getSite().getShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInput(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private ITranslationUnit fResult;

        private HistoryListDialog(Shell shell, ITranslationUnit[] elements) {
            super(shell);
            this.setHelpAvailable(false);
            this.setTitle(IBMessages.IBHistoryListAction_HistoryDialog_title);
            String[] buttonLabels = new String[]{IBMessages.IBHistoryListAction_Remove_label};
            IListAdapter adapter = new IListAdapter(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void customButtonPressed(ListDialogField field, int index) {
                    HistoryListDialog.access$0(this.this$1);
                }

                public void selectionChanged(ListDialogField field) {
                    HistoryListDialog.access$1(this.this$1);
                }

                public void doubleClicked(ListDialogField field) {
                    HistoryListDialog.access$2(this.this$1);
                }
            };
            CUILabelProvider labelProvider = new CUILabelProvider(0x8000000, 1);
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (IBaseLabelProvider)labelProvider);
            this.fHistoryList.setLabelText(IBMessages.IBHistoryListAction_HistoryList_label);
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection((Object)elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(parent.getFont());
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (ITranslationUnit)selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public ITranslationUnit getResult() {
            return this.fResult;
        }

        public ITranslationUnit[] getRemaining() {
            List elems = this.fHistoryList.getElements();
            return elems.toArray(new ITranslationUnit[elems.size()]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }

        static /* synthetic */ void access$0(HistoryListDialog historyListDialog) {
            historyListDialog.doCustomButtonPressed();
        }

        static /* synthetic */ void access$1(HistoryListDialog historyListDialog) {
            historyListDialog.doSelectionChanged();
        }

        static /* synthetic */ void access$2(HistoryListDialog historyListDialog) {
            historyListDialog.doDoubleClicked();
        }
    }
}

