/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenDefinitionAction
extends IndexAction {
    public OpenDefinitionAction(TreeViewer viewer) {
        super(viewer, CUIPlugin.getResourceString("IndexView.openDefinition.name"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProjects());
            Object[] objs = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (true) {
                if (i >= objs.length) {
                    return;
                }
                if (objs[i] instanceof IIndexBinding) {
                    Object var9_10;
                    index.acquireReadLock();
                    try {
                        IIndexBinding binding = (IIndexBinding)objs[i];
                        IIndexName[] defs = index.findDefinitions((IBinding)binding);
                        int j = 0;
                        while (j < defs.length) {
                            IIndexName name = defs[j];
                            this.showInEditor(name);
                            ++j;
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        index.releaseReadLock();
                        throw throwable;
                    }
                    {
                        var9_10 = null;
                    }
                    index.releaseReadLock();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            return;
        }
        catch (InterruptedException interruptedException) {}
    }

    private void showInEditor(IIndexName name) throws CModelException, PartInitException, CoreException {
        IEditorPart editor;
        IPath path = IndexLocationFactory.getPath((IIndexFileLocation)name.getFile().getLocation());
        if (path != null && (editor = EditorUtility.openInEditor(path, null)) != null && editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            int nodeOffset = name.getNodeOffset();
            int nodeLength = name.getNodeLength();
            try {
                if (nodeLength == -1) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    nodeOffset = document.getLineOffset(nodeOffset);
                    nodeLength = document.getLineLength(nodeOffset);
                }
                textEditor.selectAndReveal(nodeOffset, nodeLength);
            }
            catch (BadLocationException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
    }

    public boolean valid() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof IIndexBinding) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

