/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.WorkspaceLanguageConfiguration;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.language.LanguageVerifier;
import org.eclipse.cdt.internal.ui.language.WorkspaceLanguageMappingWidget;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkspaceLanguageMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    WorkspaceLanguageConfiguration fMappings;
    WorkspaceLanguageMappingWidget fMappingWidget = new WorkspaceLanguageMappingWidget();

    protected Control createContents(Composite parent) {
        try {
            this.fetchMappings();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return this.fMappingWidget.createContents(parent, PreferencesMessages.WorkspaceLanguagesPreferencePage_description);
    }

    private void fetchMappings() throws CoreException {
        this.fMappings = LanguageManager.getInstance().getWorkspaceLanguageConfiguration();
        Map availableLanguages = LanguageVerifier.computeAvailableLanguages();
        Set missingLanguages = LanguageVerifier.removeMissingLanguages(this.fMappings, availableLanguages);
        if (missingLanguages.size() > 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 40);
            messageBox.setText(PreferencesMessages.LanguageMappings_missingLanguageTitle);
            String affectedLanguages = LanguageVerifier.computeAffectedLanguages(missingLanguages);
            messageBox.setMessage(Messages.format(PreferencesMessages.WorkspaceLanguagesPreferencePage_missingLanguage, affectedLanguages));
            messageBox.open();
        }
        this.fMappingWidget.setMappings(this.fMappings.getWorkspaceMappings());
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        try {
            IContentType[] affectedContentTypes = this.fMappingWidget.getAffectedContentTypes();
            LanguageManager manager = LanguageManager.getInstance();
            WorkspaceLanguageConfiguration config = manager.getWorkspaceLanguageConfiguration();
            config.setWorkspaceMappings(this.fMappingWidget.getContentTypeMappings());
            manager.storeWorkspaceLanguageConfiguration(affectedContentTypes);
            return true;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return false;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this.fetchMappings();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
    }
}

