/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.internal.ui.preferences.formatter.CPreview;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class BracesTabPage
extends ModifyDialogTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private static final String PREVIEW = String.valueOf(BracesTabPage.createPreviewHeader(FormatterMessages.BracesTabPage_preview_header)) + "#include <math.h>\n\n" + "int digits[]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 };" + "\n\n" + "class Point {" + "public:" + "Point(double xc, double yc) : x(xc), y(yc) {}" + "double distance(const Point& other) const;" + "int compareX(const Point& other) const;" + "double x;" + "double y;" + "};" + "\n\n" + "double Point::distance(const Point& other) const {" + "double dx = x - other.x;" + "double dy = y - other.y;" + "return sqrt(dx * dx + dy * dy);" + "}" + "\n\n" + "int Point::compareX(const Point& other) const {" + "if(x < other.x) {" + "return -1;" + "} else if(x > other.x){" + "return 1;" + "} else {" + "return 0;" + "}" + "}" + "\n\n" + "namespace FOO {" + "int foo(int bar) const {" + "switch(bar) {" + "case 0:" + "++bar;" + "break;" + "case 1:" + "--bar;" + "default: {" + "bar += bar;" + "break;" + "}" + "}" + "}" + "} // end namespace FOO";
    private TranslationUnitPreview fPreview;
    private final String[] fBracePositions = new String[]{"end_of_line", "next_line", "next_line_shifted"};
    private final String[] fExtendedBracePositions = new String[]{"end_of_line", "next_line", "next_line_shifted", "next_line_on_wrap"};
    private final String[] fBracePositionNames = new String[]{FormatterMessages.BracesTabPage_position_same_line, FormatterMessages.BracesTabPage_position_next_line, FormatterMessages.BracesTabPage_position_next_line_indented};
    private final String[] fExtendedBracePositionNames = new String[]{FormatterMessages.BracesTabPage_position_same_line, FormatterMessages.BracesTabPage_position_next_line, FormatterMessages.BracesTabPage_position_next_line_indented, FormatterMessages.BracesTabPage_position_next_line_on_wrap};

    public BracesTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group group = this.createGroup(numColumns, composite, FormatterMessages.BracesTabPage_group_brace_positions_title);
        this.createExtendedBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_class_declaration, "org.eclipse.cdt.core.formatter.brace_position_for_type_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_method_declaration, "org.eclipse.cdt.core.formatter.brace_position_for_method_declaration");
        this.createExtendedBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_blocks, "org.eclipse.cdt.core.formatter.brace_position_for_block");
        this.createExtendedBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_blocks_in_case, "org.eclipse.cdt.core.formatter.brace_position_for_block_in_case");
        this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_switch_case, "org.eclipse.cdt.core.formatter.brace_position_for_switch");
        ModifyDialogTabPage.ComboPreference arrayInitOption = this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_array_initializer, "org.eclipse.cdt.core.formatter.brace_position_for_array_initializer");
        final ModifyDialogTabPage.CheckboxPreference arrayInitCheckBox = this.createIndentedCheckboxPref((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_keep_empty_array_initializer_on_one_line, "org.eclipse.cdt.core.formatter.keep_empty_array_initializer_on_one_line", FALSE_TRUE);
        arrayInitOption.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                BracesTabPage.this.updateOptionEnablement((ModifyDialogTabPage.ComboPreference)o, arrayInitCheckBox);
            }
        });
        this.updateOptionEnablement(arrayInitOption, arrayInitCheckBox);
    }

    protected final void updateOptionEnablement(ModifyDialogTabPage.ComboPreference arrayInitOption, ModifyDialogTabPage.CheckboxPreference arrayInitCheckBox) {
        arrayInitCheckBox.setEnabled(!arrayInitOption.hasValue("end_of_line"));
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected CPreview doCreateCPreview(Composite parent) {
        this.fPreview = new TranslationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    private ModifyDialogTabPage.ComboPreference createBracesCombo(Composite composite, int numColumns, String message, String key) {
        return this.createComboPref(composite, numColumns, message, key, this.fBracePositions, this.fBracePositionNames);
    }

    private ModifyDialogTabPage.ComboPreference createExtendedBracesCombo(Composite composite, int numColumns, String message, String key) {
        return this.createComboPref(composite, numColumns, message, key, this.fExtendedBracePositions, this.fExtendedBracePositionNames);
    }

    private ModifyDialogTabPage.CheckboxPreference createIndentedCheckboxPref(Composite composite, int numColumns, String message, String key, String[] values) {
        ModifyDialogTabPage.CheckboxPreference pref = this.createCheckboxPref(composite, numColumns, message, key, values);
        GridData data = (GridData)pref.getControl().getLayoutData();
        data.horizontalIndent = this.fPixelConverter.convertWidthInCharsToPixels(1);
        return pref;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }
}

