/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchListContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchListLabelProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTreeLabelProvider;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDOMSearchViewPage
extends AbstractTextSearchViewPage {
    private IPDOMSearchContentProvider contentProvider;

    public PDOMSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public PDOMSearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new PDOMSearchTreeContentProvider();
        viewer.setContentProvider((IContentProvider)((PDOMSearchTreeContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new PDOMSearchTreeLabelProvider(this));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new PDOMSearchListContentProvider();
        viewer.setContentProvider((IContentProvider)((PDOMSearchListContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new PDOMSearchListLabelProvider(this));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (!(match instanceof PDOMSearchMatch)) {
            return;
        }
        try {
            Path path = new Path(((PDOMSearchMatch)match).getFileName());
            IEditorPart editor = EditorUtility.openInEditor((IPath)path, null);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }
}

