/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;

public class OpenDeclarationsAction
extends SelectionParseAction {
    public static boolean sIsJUnitTest = false;
    public static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    ITextSelection selNode;
    static /* synthetic */ Class class$0;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
    }

    public void run() {
        this.selNode = this.getSelectedStringFromEditor();
        if (this.selNode != null) {
            new Runner().schedule();
        }
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void runSync() {
        this.selNode = this.getSelectedStringFromEditor();
        if (this.selNode != null) {
            new Runner().run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class Runner
    extends Job
    implements ASTCache.ASTRunnable {
        private IWorkingCopy fWorkingCopy;
        private IIndex fIndex;

        Runner() {
            super(CEditorMessages.getString("OpenDeclarations.dialog.title"));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                IStatus iStatus;
                OpenDeclarationsAction.this.clearStatusLine();
                this.fWorkingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(OpenDeclarationsAction.this.fEditor.getEditorInput());
                if (this.fWorkingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                this.fIndex = CCorePlugin.getIndexManager().getIndex(this.fWorkingCopy.getCProject(), 3);
                try {
                    this.fIndex.acquireReadLock();
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    iStatus = ASTProvider.getASTProvider().runOnAST((ICElement)this.fWorkingCopy, ASTProvider.WAIT_YES, monitor, this);
                    Object var2_3 = null;
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    this.fIndex.releaseReadLock();
                    throw throwable;
                }
                this.fIndex.releaseReadLock();
                return iStatus;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
            int selectionLength;
            int selectionStart = OpenDeclarationsAction.this.selNode.getOffset();
            IASTName[] selectedNames = lang.getSelectedNames(ast, selectionStart, selectionLength = OpenDeclarationsAction.this.selNode.getLength());
            if (selectedNames.length > 0 && selectedNames[0] != null) {
                boolean found = false;
                IASTName searchName = selectedNames[0];
                boolean isDefinition = searchName.isDefinition();
                IBinding binding = searchName.resolveBinding();
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    ICPPMethod method;
                    IName[] declNames = this.findNames(this.fIndex, ast, isDefinition, binding);
                    if (declNames.length == 0 && binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit()) {
                        try {
                            ICPPClassType clsBinding = method.getClassOwner();
                            if (clsBinding != null && !(clsBinding instanceof IProblemBinding)) {
                                declNames = this.findNames(this.fIndex, ast, false, (IBinding)clsBinding);
                            }
                        }
                        catch (DOMException dOMException) {}
                    }
                    found = this.navigateViaCElements(this.fWorkingCopy.getCProject(), this.fIndex, declNames) ? true : this.navigateOneLocation(declNames);
                }
                if (!found) {
                    OpenDeclarationsAction.this.reportSymbolLookupFailure(new String(searchName.toCharArray()));
                }
            } else {
                IASTPreprocessorStatement[] preprocs = ast.getAllPreprocessorStatements();
                boolean foundInInclude = false;
                int i = 0;
                while (i < preprocs.length) {
                    if (preprocs[i] instanceof IASTPreprocessorIncludeStatement) {
                        IASTPreprocessorIncludeStatement incStmt = (IASTPreprocessorIncludeStatement)preprocs[i];
                        IASTFileLocation loc = preprocs[i].getFileLocation();
                        if (loc != null && loc.getFileName().equals(ast.getFilePath()) && loc.getNodeOffset() < selectionStart && loc.getNodeOffset() + loc.getNodeLength() > selectionStart) {
                            foundInInclude = true;
                            String name = null;
                            if (incStmt.isResolved()) {
                                name = incStmt.getPath();
                            }
                            if (name != null) {
                                Path path = new Path(name);
                                OpenDeclarationsAction.this.runInUIThread(new Runnable(this, (IPath)path){
                                    final /* synthetic */ Runner this$1;
                                    private final /* synthetic */ IPath val$path;
                                    {
                                        this.this$1 = runner;
                                        this.val$path = iPath;
                                    }

                                    public void run() {
                                        try {
                                            Runner.access$0(this.this$1).open(this.val$path, 0, 0);
                                        }
                                        catch (CoreException e) {
                                            CUIPlugin.getDefault().log(e);
                                        }
                                    }
                                });
                                break;
                            }
                            OpenDeclarationsAction.this.reportIncludeLookupFailure(new String(incStmt.getName().toCharArray()));
                            break;
                        }
                        if (!foundInInclude) {
                            OpenDeclarationsAction.this.reportSelectionMatchFailure();
                        }
                    }
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }

        private boolean navigateOneLocation(IName[] declNames) {
            int i = 0;
            while (i < declNames.length) {
                IASTFileLocation fileloc = declNames[i].getFileLocation();
                if (fileloc != null) {
                    Path path = new Path(fileloc.getFileName());
                    int offset = fileloc.getNodeOffset();
                    int length = fileloc.getNodeLength();
                    OpenDeclarationsAction.this.runInUIThread(new Runnable(this, (IPath)path, offset, length){
                        final /* synthetic */ Runner this$1;
                        private final /* synthetic */ IPath val$path;
                        private final /* synthetic */ int val$offset;
                        private final /* synthetic */ int val$length;
                        {
                            this.this$1 = runner;
                            this.val$path = iPath;
                            this.val$offset = n;
                            this.val$length = n2;
                        }

                        public void run() {
                            try {
                                Runner.access$0(this.this$1).open(this.val$path, this.val$offset, this.val$length);
                            }
                            catch (CoreException e) {
                                CUIPlugin.getDefault().log(e);
                            }
                        }
                    });
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean navigateViaCElements(ICProject project, IIndex index, IName[] declNames) {
            ArrayList<ICElementHandle> elements = new ArrayList<ICElementHandle>();
            int i = 0;
            while (i < declNames.length) {
                try {
                    ICElementHandle elem = IndexUI.getCElementForName(project, index, declNames[i]);
                    if (elem instanceof ISourceReference) {
                        elements.add(elem);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
                ++i;
            }
            if (elements.isEmpty()) {
                return false;
            }
            OpenDeclarationsAction.this.runInUIThread(new Runnable(this, elements){
                final /* synthetic */ Runner this$1;
                private final /* synthetic */ ArrayList val$elements;
                {
                    this.this$1 = runner;
                    this.val$elements = arrayList;
                }

                public void run() {
                    ISourceReference target = null;
                    if (this.val$elements.size() == 1) {
                        target = (ISourceReference)this.val$elements.get(0);
                    } else {
                        if (sIsJUnitTest) {
                            throw new RuntimeException("ambiguous input");
                        }
                        ICElement[] elemArray = this.val$elements.toArray(new ICElement[this.val$elements.size()]);
                        target = (ISourceReference)OpenActionUtil.selectCElement(elemArray, Runner.access$0(this.this$1).getSite().getShell(), CEditorMessages.getString("OpenDeclarationsAction.dialog.title"), CEditorMessages.getString("OpenDeclarationsAction.selectMessage"), -2147483647, 0);
                    }
                    if (target != null) {
                        ITranslationUnit tu = target.getTranslationUnit();
                        try {
                            ISourceRange sourceRange = target.getSourceRange();
                            if (tu != null && sourceRange != null) {
                                Runner.access$0(this.this$1).open(tu.getLocation(), sourceRange.getIdStartPos(), sourceRange.getIdLength());
                            }
                        }
                        catch (CoreException e) {
                            CUIPlugin.getDefault().log(e);
                        }
                    }
                }
            });
            return true;
        }

        private IName[] findNames(IIndex index, IASTTranslationUnit ast, boolean isDefinition, IBinding binding) throws CoreException {
            IName[] declNames;
            IName[] iNameArray = declNames = isDefinition ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, binding);
            if (declNames.length == 0) {
                declNames = isDefinition ? this.findDefinitions(index, ast, binding) : this.findDeclarations(index, ast, binding);
            }
            return declNames;
        }

        private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
            IASTName[] declNames = ast.getDefinitionsInAST(binding);
            if (declNames.length == 0) {
                declNames = index.findDefinitions(binding);
            }
            return declNames;
        }

        private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
            Object[] declNames = ast.getDeclarationsInAST(binding);
            int i = 0;
            while (i < declNames.length) {
                IASTName name = declNames[i];
                if (name.isDefinition()) {
                    declNames[i] = null;
                }
                ++i;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.IName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((declNames = (IName[])ArrayUtil.removeNulls((Class)clazz, (Object[])declNames)).length == 0) {
                declNames = index.findNames(binding, 1);
            }
            return declNames;
        }

        static /* synthetic */ OpenDeclarationsAction access$0(Runner runner) {
            return runner.OpenDeclarationsAction.this;
        }
    }
}

