/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.typehierarchy.THViewPart;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class THDropTargetListener
implements DropTargetListener {
    private ICElement fInput;
    private boolean fEnabled = true;
    private IWorkbenchWindow fWindow;
    static /* synthetic */ Class class$0;

    public THDropTargetListener(THViewPart view) {
        this.fWindow = view.getSite().getWorkbenchWindow();
    }

    public void setEnabled(boolean val) {
        this.fEnabled = val;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fInput = null;
        this.checkOperation(event);
        if (event.detail != 0 && LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            this.fInput = this.checkLocalSelection();
            if (!TypeHierarchyUI.isValidInput(this.fInput)) {
                event.detail = 0;
                this.fInput = null;
            }
        }
    }

    private ICElement checkLocalSelection() {
        ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
        if (sel instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                ICElement adapter;
                Object element = iter.next();
                if (element instanceof ICElement) {
                    return (ICElement)element;
                }
                if (!(element instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ICElement)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                return adapter;
            }
        }
        return null;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.checkOperation(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.fInput == null) {
            Display.getCurrent().beep();
        } else {
            TypeHierarchyUI.open(this.fInput, this.fWindow);
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void checkOperation(DropTargetEvent event) {
        event.detail = this.fEnabled && (event.operations & 1) != 0 ? 1 : 0;
    }
}

