/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    static /* synthetic */ Class class$0;

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (CModelException cModelException) {}
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws CModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        if (element != null && part instanceof CEditor) {
            ((CEditor)part).setSelection(element);
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        if (!file.getProject().isAccessible()) {
            EditorUtility.closedProject(file.getProject());
            return null;
        }
        if (file != null) {
            try {
                IEditorInput input;
                File tempFile;
                if (!EditorUtility.isLinked(file) && (tempFile = file.getRawLocation().toFile()) != null) {
                    String canonicalPath = null;
                    try {
                        canonicalPath = tempFile.getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                    if (canonicalPath != null) {
                        Path path = new Path(canonicalPath);
                        file = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    }
                }
                if ((input = EditorUtility.getEditorInput(file)) != null) {
                    return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, file), activate);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public static boolean isLinked(IFile file) {
        if (file.isLinked()) {
            return true;
        }
        IPath path = file.getLocation();
        while (path.segmentCount() > 0) {
            path = path.removeLastSegments(1);
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(path);
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IFolder && ((IFolder)containers[i]).isLinked()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void closedProject(IProject project) {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString("EditorUtility.closedproject"));
        String desc = CUIPlugin.getResourceString("Editorutility.closedproject.description");
        errorMsg.setMessage(MessageFormat.format(desc, project.getName()));
        errorMsg.open();
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            return editorPart;
        }
        return null;
    }

    private static IEditorInput getEditorInput(ICElement element) throws CModelException {
        while (element != null) {
            ITranslationUnit tu;
            if (element instanceof ISourceReference && (tu = ((ISourceReference)element).getTranslationUnit()) != null) {
                element = tu;
            }
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ITranslationUnit) {
                ITranslationUnit unit = (ITranslationUnit)element;
                IResource resource = unit.getResource();
                if (resource instanceof IFile) {
                    return new FileEditorInput((IFile)resource);
                }
                return new ExternalEditorInput(unit, (IStorage)new FileStorage(unit.getPath()));
            }
            if (element instanceof IBinary) {
                return new ExternalEditorInput(EditorUtility.getStorage((IBinary)element), null);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws CModelException {
        if (input instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new ExternalEditorInput((IStorage)input);
        }
        return null;
    }

    public static IEditorPart openInEditor(IPath location, ICElement element) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(location, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), true);
    }

    public static IEditorInput getEditorInputForLocation(IPath location, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(location, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block2: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        if (includeReferences[j].isOnIncludeEntry(location)) {
                            context = projects[i];
                            break block2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException cModelException) {}
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, location);
            if (unit != null) {
                return new ExternalEditorInput(unit, (IStorage)new FileStorage(location));
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput((IStorage)new FileStorage(location), (IResource)markerResource);
        }
        return new ExternalEditorInput((IStorage)new FileStorage(location));
    }

    private static IFile getWorkspaceFileAtLocation(IPath location, ICElement context) {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        if (file == null) {
            ICProject cProject;
            IProject project = null;
            if (context != null && (cProject = context.getCProject()) != null) {
                project = cProject.getProject();
            }
            IFile bestMatch = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = root.findFilesForLocation(location);
            int i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.isAccessible()) {
                    if (project != null && file.getProject() == project) {
                        bestMatch = file;
                        break;
                    }
                    if (bestMatch == null) {
                        bestMatch = file;
                        if (project == null) break;
                    }
                }
                ++i;
            }
            return bestMatch;
        }
        return file;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICElement)editorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    public static ITranslationUnit getWorkingCopy(ITranslationUnit cu) {
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            return cu;
        }
        return cu.findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory());
    }

    public static String getEditorID(String name) {
        IEditorDescriptor descriptor;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null && (descriptor = registry.getDefaultEditor(name)) != null) {
            return descriptor.getId();
        }
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        Object editorInput;
        ITranslationUnit tunit = null;
        if (inputObject instanceof ITranslationUnit) {
            tunit = (ITranslationUnit)inputObject;
        } else if (input instanceof IFileEditorInput) {
            editorInput = (IFileEditorInput)input;
            IFile file = editorInput.getFile();
            ICElement celement = CoreModel.getDefault().create(file);
            if (celement instanceof ITranslationUnit) {
                tunit = (ITranslationUnit)celement;
            }
        } else if (input instanceof ITranslationUnitEditorInput) {
            editorInput = (ITranslationUnitEditorInput)input;
            tunit = editorInput.getTranslationUnit();
        }
        if (tunit != null) {
            String contentTypeId = tunit.getContentTypeId();
            if (contentTypeId != null) {
                IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor desc = registry.getDefaultEditor(input.getName(), contentType);
                if (desc != null) {
                    return desc.getId();
                }
            }
            if (tunit.isCLanguage()) {
                return "org.eclipse.cdt.ui.editor.CEditor";
            }
            if (tunit.isCXXLanguage()) {
                return "org.eclipse.cdt.ui.editor.CEditor";
            }
            if (tunit.isASMLanguage()) {
                return "org.eclipse.cdt.ui.editor.asm.AsmEditor";
            }
        }
        String editorId = EditorUtility.getEditorID(input.getName());
        return editorId;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return CEditorMessages.getFormattedString("EditorUtility.concatModifierStrings", new String[]{modifierString, newModifierString});
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store = null;
        try {
            IBuffer buffer = bin.getBuffer();
            if (buffer != null) {
                store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.getContents().getBytes()), bin.getPath());
            }
        }
        catch (CModelException cModelException) {}
        return store;
    }

    public static IStorage getStorage(ITranslationUnit tu) {
        FileStorage store = null;
        try {
            store = new FileStorage((InputStream)new ByteArrayInputStream(tu.getBuffer().getContents().getBytes()), tu.getPath());
        }
        catch (CModelException cModelException) {}
        return store;
    }
}

