/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.internal.ui.workingsets.CElementWorkingSetPageContentProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class CElementWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.getString("CElementWorkingSetPage.title");
    private static final String PAGE_ID = "CElementWorkingSetPage";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private IWorkingSet fWorkingSet;
    private boolean fFirstCheck;
    private ITreeContentProvider fTreeContentProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CElementWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, CPluginImages.DESC_WIZABAN_C_APP);
        this.setDescription(WorkingSetMessages.getString("CElementWorkingSetPage.description"));
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.name"));
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CElementWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.content"));
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 50;
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new CElementWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider cElementLabelProvider = new AppearanceAwareLabelProvider(0x40000001, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(cElementLabelProvider));
        this.fTree.setSorter((ViewerSorter)new CElementSorter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)CoreModel.create((IWorkspaceRoot)CUIPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CElementWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!CElementWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)CElementWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            CElementWorkingSetPage.access$1(3.access$0(this.this$1), this.val$element, CElementWorkingSetPage.access$0(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ CElementWorkingSetPage access$0(3 var0) {
                return var0.CElementWorkingSetPage.this;
            }
        });
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            HashSet<IProject> closedWithChildren = new HashSet<IProject>(elements.size());
            int i = 0;
            while (i < oldItems.length) {
                IProject project;
                IResource oldResource = null;
                if (oldItems[i] instanceof IResource) {
                    oldResource = (IResource)oldItems[i];
                } else {
                    IAdaptable iAdaptable = oldItems[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    oldResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (oldResource != null && !oldResource.isAccessible() && (closedWithChildren.contains(project = oldResource.getProject()) || elements.contains(project))) {
                    elements.add(oldItems[i]);
                    elements.remove(project);
                    closedWithChildren.add(project);
                }
                ++i;
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                CElementWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                if (CElementWorkingSetPage.this.isExpandable(element)) {
                    CElementWorkingSetPage.this.setSubtreeChecked(element, state, true);
                }
                CElementWorkingSetPage.this.updateParentState(element, state);
                CElementWorkingSetPage.this.validateInput();
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof ICProject || element instanceof ICContainer || element instanceof CElementGrouping || element instanceof ICModel || element instanceof IContainer;
    }

    private void updateParentState(Object child, boolean baseChildState) {
        Object parent;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)child;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && !resource.isAccessible()) {
                return;
            }
        }
        if ((parent = this.fTreeContentProvider.getParent(child)) == null) {
            return;
        }
        this.updateObjectState(parent, baseChildState);
    }

    private void updateObjectState(Object element, boolean baseChildState) {
        boolean allSameState = true;
        Object[] children = this.fTreeContentProvider.getChildren(element);
        int i = children.length - 1;
        while (i >= 0) {
            if (this.fTree.getChecked(children[i]) != baseChildState || this.fTree.getGrayed(children[i])) {
                allSameState = false;
                break;
            }
            --i;
        }
        this.fTree.setGrayed(element, !allSameState);
        this.fTree.setChecked(element, !allSameState || baseChildState);
        this.updateParentState(element, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] elements;
                if (CElementWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = CUIPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = CUIPlugin.getActivePage().getActivePart();
                    if (part == null) {
                        return;
                    }
                    try {
                        elements = SelectionConverter.getStructuredSelection(part).toArray();
                        int i = 0;
                        while (i < elements.length) {
                            if (elements[i] instanceof IResource) {
                                ICElement ce;
                                IResource iResource = (IResource)elements[i];
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((ce = (ICElement)iResource.getAdapter((Class)clazz)) != null && ce.exists() && ce.getCProject().isOnSourceRoot((IResource)elements[i])) {
                                    elements[i] = ce;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (CModelException cModelException) {
                        return;
                    }
                }
                elements = CElementWorkingSetPage.this.fWorkingSet.getElements();
                int i = 0;
                while (i < elements.length) {
                    ICProject cProject;
                    IAdaptable element = elements[i];
                    if (element instanceof IResource) {
                        ICElement cElement;
                        IProject project = ((IResource)element).getProject();
                        if (!project.isAccessible()) {
                            elements[i] = project;
                        } else if (CoreModel.hasCNature((IProject)project) && (cElement = CoreModel.getDefault().create((IResource)element)) != null) {
                            elements[i] = cElement;
                        }
                    } else if (element instanceof ICElement && (cProject = ((ICElement)element).getCProject()) != null && !cProject.getProject().isAccessible()) {
                        elements[i] = cProject.getProject();
                    }
                    ++i;
                }
                CElementWorkingSetPage.this.fTree.setCheckedElements(elements);
                HashSet<Object> parents = new HashSet<Object>();
                int i2 = 0;
                while (i2 < elements.length) {
                    block31: {
                        Object parent;
                        Object element;
                        block30: {
                            IResource resource;
                            element = elements[i2];
                            if (CElementWorkingSetPage.this.isExpandable(element)) {
                                CElementWorkingSetPage.this.setSubtreeChecked(element, true, true);
                            }
                            if (!(element instanceof IAdaptable)) break block30;
                            IAdaptable iAdaptable = (IAdaptable)element;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && !resource.isAccessible()) break block31;
                        }
                        if ((parent = CElementWorkingSetPage.this.fTreeContentProvider.getParent(element)) != null) {
                            parents.add(parent);
                        }
                    }
                    ++i2;
                }
                Iterator i22 = parents.iterator();
                while (i22.hasNext()) {
                    CElementWorkingSetPage.this.updateObjectState(i22.next(), true);
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(workingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)parent;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer container = (IContainer)iAdaptable.getAdapter((Class)clazz);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = children.length - 1;
        while (i >= 0) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (this.isExpandable(element)) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.workingSetExists");
                }
                ++i;
            }
        }
        if (errorMessage == null && this.fTree.getCheckedElements().length == 0) {
            String infoMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.resourceMustBeChecked");
            this.setMessage(infoMessage, 1);
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private void findCheckedElements(List checkedElements, Object parent) {
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        int i = 0;
        while (i < children.length) {
            if (this.fTree.getGrayed(children[i])) {
                this.findCheckedElements(checkedElements, children[i]);
            } else if (this.fTree.getChecked(children[i])) {
                checkedElements.add(children[i]);
            }
            ++i;
        }
    }
}

