/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class CElementWorkingSetUpdater
implements IWorkingSetUpdater,
IElementChangedListener {
    public static final String ID = "org.eclipse.cdt.ui.CElementWorkingSetPage";
    private List fWorkingSets = new ArrayList();

    public CElementWorkingSetUpdater() {
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
    }

    public void add(final IWorkingSet workingSet) {
        WorkingSetCheck check = new WorkingSetCheck(workingSet);
        check.setUser(false);
        check.setPriority(20);
        check.schedule(1000L);
        check.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                List list = CElementWorkingSetUpdater.this.fWorkingSets;
                synchronized (list) {
                    CElementWorkingSetUpdater.this.fWorkingSets.add(workingSet);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(ElementChangedEvent event) {
        IWorkingSet[] workingSets;
        List list = this.fWorkingSets;
        synchronized (list) {
            workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int w = 0;
        while (w < workingSets.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSets[w]);
            this.processCElementDelta(workingSetDelta, event.getDelta());
            IResourceDelta[] resourceDeltas = event.getDelta().getResourceDeltas();
            if (resourceDeltas != null) {
                int r = 0;
                while (r < resourceDeltas.length) {
                    this.processResourceDelta(workingSetDelta, resourceDeltas[r]);
                    ++r;
                }
            }
            workingSetDelta.process();
            ++w;
        }
    }

    private void processCElementDelta(WorkingSetDelta result, ICElementDelta delta) {
        ICElement cElement = delta.getElement();
        int index = result.indexOf(cElement);
        int type = cElement.getElementType();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (type == 11 && kind == 4) {
            if (index != -1 && (flags & 0x80) != 0) {
                result.set(index, ((ICProject)cElement).getProject());
            } else if ((flags & 0x40) != 0 && (index = result.indexOf(((ICProject)cElement).getProject())) != -1) {
                result.set(index, cElement);
            }
        } else if (type == 11 && kind == 2) {
            if (index != -1) {
                result.set(index, ((ICProject)cElement).getProject());
            }
        } else if (type == 11 && kind == 1) {
            index = result.indexOf(((ICProject)cElement).getProject());
            if (index != -1) {
                result.set(index, cElement);
            }
        } else if (index != -1 && kind == 2) {
            if ((flags & 0x20) != 0) {
                result.set(index, delta.getMovedToElement());
            } else {
                result.remove(index);
            }
        }
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                this.processResourceDelta(result, resourceDeltas[i]);
                ++i;
            }
        }
        ICElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processCElementDelta(result, children[i]);
            ++i;
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta delta) {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        if (this.projectGotClosedOrOpened(resource, kind, flags)) {
            return;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processResourceDelta(result, children[i]);
            ++i;
        }
    }

    private boolean projectGotClosedOrOpened(IResource resource, int kind, int flags) {
        return resource.getType() == 4 && kind == 4 && (flags & 0x4000) != 0;
    }

    private static void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IProject project;
            IAdaptable element = (IAdaptable)iter.next();
            boolean remove = false;
            if (element instanceof ICElement) {
                ICElement cElement = (ICElement)element;
                remove = cElement instanceof ICProject ? !cElement.exists() : (project = cElement.getCProject().getProject()).isOpen() && !cElement.exists();
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                if (resource instanceof IProject) {
                    remove = !resource.exists();
                } else {
                    project = resource.getProject();
                    boolean bl = remove = (project == null || project.isOpen()) && !resource.exists();
                }
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private static class WorkingSetCheck
    extends Job {
        private final IWorkingSet fWorkingSet;

        WorkingSetCheck(IWorkingSet workingSet) {
            super("Check WorkingSet");
            this.fWorkingSet = workingSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IWorkingSet iWorkingSet = this.fWorkingSet;
            synchronized (iWorkingSet) {
                CElementWorkingSetUpdater.checkElementExistence(this.fWorkingSet);
            }
            return Status.OK_STATUS;
        }
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WorkingSetDelta(IWorkingSet workingSet) {
            IWorkingSet iWorkingSet = this.fWorkingSet = workingSet;
            synchronized (iWorkingSet) {
                this.fElements = new ArrayList<IAdaptable>(Arrays.asList(this.fWorkingSet.getElements()));
            }
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, Object element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

