/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.ExPatternDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class CLocationTab
extends AbstractCPropertyTab {
    private final Image IMG_EN = CPluginImages.get("org.eclipse.cdt.ui.cfolder_obj.gif");
    private final Image IMG_FI = CPluginImages.get("org.eclipse.cdt.ui.exclusion_filter_attrib.gif");
    Label label;
    TreeViewer tree;
    ArrayList src;
    ICResourceDescription cfgd;
    ICProject cprj;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.label = new Label(this.usercomp, 0);
        this.label.setLayoutData((Object)new GridData(1));
        this.tree = new TreeViewer(this.usercomp);
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.tree.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CLocationTab.this.updateButtons();
            }
        });
        this.initButtons(new String[]{UIMessages.getString("CLocationTab.4"), UIMessages.getString("CLocationTab.5"), UIMessages.getString("CLocationTab.6"), UIMessages.getString("CLocationTab.7")}, 150);
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof _Entry) {
                    return ((_Entry)parentElement).f;
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof _Filter) {
                    return ((_Filter)element).entry;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof _Entry;
            }

            public Object[] getElements(Object inputElement) {
                return CLocationTab.this.src.toArray(new _Entry[CLocationTab.this.src.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof _Entry) {
                    return CLocationTab.this.IMG_EN;
                }
                if (element instanceof _Filter) {
                    return CLocationTab.this.IMG_FI;
                }
                return null;
            }
        });
    }

    protected void updateButtons() {
        TreeItem[] sel = this.tree.getTree().getSelection();
        this.buttonSetEnabled(2, sel.length == 1);
        this.buttonSetEnabled(3, sel.length > 0 && sel[0].getData() instanceof _Entry);
    }

    public void buttonPressed(int x) {
        Shell shell = this.usercomp.getShell();
        TreeItem[] sel = this.tree.getTree().getSelection();
        switch (x) {
            case 0: {
                String s = this.getProjectDialog(shell, "");
                if (s == null) break;
                this.src.add(new _Entry(this.newEntry((IPath)new Path(s), new IPath[0], true)));
                this.saveData();
                break;
            }
            case 1: {
                NewFolderDialog d = new NewFolderDialog(shell, (IContainer)this.page.getProject());
                if (d.open() == 0) {
                    IFolder f = (IFolder)d.getFirstResult();
                    this.src.add(new _Entry(this.newEntry(f, new IPath[]{}, !f.isLinked())));
                    this.saveData();
                }
            }
            case 2: {
                if (sel.length == 0) {
                    return;
                }
                Object data = sel[0].getData();
                _Entry entry = null;
                if (data instanceof _Entry) {
                    entry = (_Entry)data;
                } else if (data instanceof _Filter) {
                    entry = ((_Filter)data).entry;
                } else {
                    return;
                }
                ExPatternDialog dialog = new ExPatternDialog(this.usercomp.getShell(), entry.ent.getExclusionPatterns(), entry.getPath(), this.page.getProject());
                if (dialog.open() != 0) break;
                IPath[] ps = dialog.getExclusionPattern();
                IPath path = entry.getPath();
                boolean isWsp = entry.ent.isValueWorkspacePath();
                entry.ent = this.newEntry(path, ps, isWsp);
                this.saveData();
                break;
            }
            case 3: {
                if (sel.length == 0) {
                    return;
                }
                int i = 0;
                while (i < sel.length) {
                    if (sel[i].getData() instanceof _Entry) {
                        this.src.remove(sel[i].getData());
                    }
                    ++i;
                }
                this.saveData();
                break;
            }
        }
    }

    public void saveData() {
        ICExclusionPatternPathEntry[] p = new ICExclusionPatternPathEntry[this.src.size()];
        Iterator it = this.src.iterator();
        int i = 0;
        while (it.hasNext()) {
            p[i++] = ((_Entry)it.next()).ent;
        }
        this.setEntries(this.cfgd, p);
        this.tree.setInput((Object)this.cfgd);
        this.updateData(this.cfgd);
    }

    public void updateData(ICResourceDescription _cfgd) {
        this.cfgd = _cfgd;
        ICExclusionPatternPathEntry[] ent = this.getEntries(this.cfgd);
        this.src = new ArrayList(ent.length);
        int i = 0;
        while (i < ent.length) {
            this.src.add(new _Entry(ent[i]));
            ++i;
        }
        this.tree.setInput((Object)this.src);
        IAdaptable ad = this.page.getElement();
        if (ad instanceof ICProject) {
            this.cprj = (ICProject)ad;
        }
        this.updateButtons();
    }

    protected abstract ICExclusionPatternPathEntry[] getEntries(ICResourceDescription var1);

    protected abstract void setEntries(ICResourceDescription var1, ICExclusionPatternPathEntry[] var2);

    protected abstract ICExclusionPatternPathEntry newEntry(IPath var1, IPath[] var2, boolean var3);

    protected abstract ICExclusionPatternPathEntry newEntry(IFolder var1, IPath[] var2, boolean var3);

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.setEntries(dst, this.getEntries(src));
    }

    protected void performDefaults() {
        this.setEntries(this.cfgd, null);
        this.updateData(this.cfgd);
    }

    public boolean canBeVisible() {
        return this.page.isForProject();
    }

    private String getProjectDialog(Shell shell, String text) {
        IResource resource;
        IContainer[] cs;
        Path path = new Path(text);
        LocDialog dialog = new LocDialog(shell);
        dialog.setInput(this.page.getProject());
        IContainer container = null;
        if (path.isAbsolute() && (cs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)path)) != null && cs.length > 0) {
            container = cs[0];
        }
        dialog.setInitialSelection(container);
        dialog.setTitle(WORKSPACE_DIR_DIALOG_TITLE);
        dialog.setMessage(WORKSPACE_DIR_DIALOG_MSG);
        if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    class LocDialog
    extends ElementTreeSelectionDialog {
        public LocDialog(Shell parent) {
            super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            this.addFilter(new ViewerFilter(this){
                final /* synthetic */ LocDialog this$1;
                {
                    this.this$1 = locDialog;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof IFolder;
                }
            });
        }
    }

    class _Entry {
        ICExclusionPatternPathEntry ent;
        _Filter[] f = new _Filter[1];

        _Entry(ICExclusionPatternPathEntry _ent) {
            this.ent = _ent;
            this.f[0] = new _Filter(this);
        }

        public String toString() {
            return this.getPath() == null ? "" : this.getPath().toString();
        }

        public IPath getPath() {
            return this.ent.isValueWorkspacePath() ? this.ent.getFullPath() : this.ent.getLocation();
        }
    }

    class _Filter {
        _Entry entry;

        _Filter(_Entry _entry) {
            this.entry = _entry;
        }

        public IPath[] getExtPaths() {
            IPath[] p = null;
            p = this.entry.ent.getExclusionPatterns();
            return p;
        }

        public String[] getExts() {
            IPath[] p = this.getExtPaths();
            if (p == null || p.length == 0) {
                return new String[0];
            }
            String[] s = new String[p.length];
            int i = 0;
            while (i < p.length) {
                s[i] = p[i].toOSString();
                ++i;
            }
            return s;
        }

        public String toString() {
            String[] s = this.getExts();
            if (s.length == 0) {
                return UIMessages.getString("CLocationTab.0");
            }
            String x = UIMessages.getString("CLocationTab.1");
            int i = 0;
            while (i < s.length) {
                x = String.valueOf(x) + s[i] + UIMessages.getString("CLocationTab.2");
                ++i;
            }
            x = String.valueOf(x.substring(0, x.length() - 2)) + UIMessages.getString("CLocationTab.3");
            return x;
        }
    }
}

