/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.ui.newui.AbstractLangsListTab;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.SymbolDialog;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.TableColumn;

public class SymbolTab
extends AbstractLangsListTab {
    public void additionalTableSet() {
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("SymbolTab.0"));
        tc.setWidth(80);
        tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("SymbolTab.1"));
        tc.setWidth(130);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("SymbolTab.0");
            }
        });
    }

    public ICLanguageSettingEntry doAdd() {
        SymbolDialog dlg = new SymbolDialog(this.usercomp.getShell(), true, UIMessages.getString("SymbolTab.2"), "", "", this.getResDesc());
        if (dlg.open() && dlg.text1.trim().length() > 0) {
            this.toAllCfgs = dlg.check1;
            this.toAllLang = dlg.check3;
            return new CMacroEntry(dlg.text1, dlg.text2, 0);
        }
        return null;
    }

    public ICLanguageSettingEntry doEdit(ICLanguageSettingEntry ent) {
        SymbolDialog dlg = new SymbolDialog(this.usercomp.getShell(), false, UIMessages.getString("SymbolTab.3"), ent.getName(), ent.getValue(), this.getResDesc());
        if (dlg.open()) {
            return new CMacroEntry(dlg.text1, dlg.text2, 0);
        }
        return null;
    }

    public int getKind() {
        return 4;
    }

    public void update() {
        if (this.lang != null) {
            int x = this.table.getSelectionIndex();
            if (x == -1) {
                x = 0;
            }
            ArrayList<ICLanguageSettingEntry> lst = new ArrayList<ICLanguageSettingEntry>();
            this.incs = new LinkedList(this.lang.getSettingEntriesList(this.getKind()));
            if (this.incs != null) {
                Iterator it = this.incs.iterator();
                while (it.hasNext()) {
                    ICLanguageSettingEntry ent = (ICLanguageSettingEntry)it.next();
                    if (ent.isBuiltIn() && !this.showBIButton.getSelection()) continue;
                    lst.add(ent);
                }
                Collections.sort(lst, CDTListComparator.getInstance());
            }
            this.tv.setInput((Object)lst.toArray(new Object[lst.size()]));
            if (this.table.getItemCount() > x) {
                this.table.select(x);
            } else if (this.table.getItemCount() > 0) {
                this.table.select(0);
            }
        }
        this.updateButtons();
    }
}

