/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProjectSelectionPage
extends WizardPage
implements IWizardDataPage {
    private static final String PAGE_NAME = "NewProjectSelectionWizardPage";
    private static final String PAGE_TITLE = Messages.getString("ProjectSelectionPage.0");
    private static final String PAGE_DESCRIPTION = Messages.getString("ProjectSelectionPage.1");
    private Label projectNameLabel;
    private Button projectBrowseButton;
    private Text projectNameText;
    private String projectName = "";
    private IWorkspaceRoot workspaceRoot;
    private ICProject currentCProject;
    private Map data = new HashMap(2);
    static /* synthetic */ Class class$0;

    public ProjectSelectionPage() {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.setPageComplete(false);
    }

    public void init(IStructuredSelection selection) {
        ICProject cProject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            selectedElement = this.getActiveEditorCInput();
        }
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject project = ((IResource)selectedElement).getProject();
            if (project != null) {
                projPath = project.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof ICElement && (cProject = ((ICElement)selectedElement).getCProject()) != null) {
            projPath = cProject.getProject().getFullPath().makeRelative().toString();
        }
        if (projPath != null) {
            this.projectName = projPath;
        } else {
            this.setDefaultAttributes();
        }
    }

    private ICElement getActiveEditorCInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICElement)editorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    private void setDefaultAttributes() {
        try {
            IProject[] projects = this.workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                    this.projectName = project.getFullPath().makeRelative().toString();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public Map getPageData() {
        String cPojectName = this.currentCProject.getResource().getName().trim();
        this.data.put("projectName", cPojectName);
        this.data.put("baseName", this.getBaseName(cPojectName));
        return this.data;
    }

    private String getBaseName(String name) {
        String baseName = name;
        int dot = baseName.lastIndexOf(46);
        if (dot != -1) {
            baseName = baseName.substring(dot + 1);
        }
        if ((dot = baseName.indexOf(32)) != -1) {
            baseName = baseName.substring(0, dot);
        }
        return baseName;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createProjectFiled(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.new_srcfldr_wizard_page_context");
        this.projectNameText.setFocus();
        this.projectNameText.setSelection(0, this.projectNameText.getText().length());
        this.setPageComplete(this.validatePage());
    }

    private void createProjectFiled(Composite parent) {
        this.getLabelControl(parent);
        GridData gdLabel = new GridData(256);
        gdLabel.horizontalSpan = 1;
        this.projectNameLabel.setLayoutData((Object)gdLabel);
        this.getTextControl(parent);
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 4;
        gdText.grabExcessHorizontalSpace = true;
        gdText.horizontalSpan = 1;
        gdText.widthHint = this.convertWidthInCharsToPixels(40);
        this.projectNameText.setLayoutData((Object)gdText);
        this.getButtonControl(parent);
        GridData gdButton = new GridData();
        gdButton.horizontalAlignment = 4;
        gdButton.grabExcessHorizontalSpace = false;
        gdButton.horizontalSpan = 1;
        this.projectBrowseButton.setLayoutData((Object)gdButton);
    }

    private void getLabelControl(Composite parent) {
        this.projectNameLabel = new Label(parent, 16448);
        this.projectNameLabel.setText(Messages.getString("ProjectSelectionPage.4"));
        this.projectNameLabel.setFont(parent.getFont());
        this.projectNameLabel.setEnabled(true);
    }

    private void getTextControl(Composite parent) {
        this.projectNameText = new Text(parent, 2052);
        this.projectNameText.setText(this.projectName);
        this.projectNameText.setFont(parent.getFont());
        this.projectNameText.setEnabled(true);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectSelectionPage.this.setPageComplete(ProjectSelectionPage.this.validatePage());
            }
        });
    }

    private void getButtonControl(Composite parent) {
        this.projectBrowseButton = new Button(parent, 8);
        this.projectBrowseButton.setText(Messages.getString("ProjectSelectionPage.5"));
        this.projectBrowseButton.setFont(parent.getFont());
        this.projectBrowseButton.setEnabled(true);
        this.projectBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionPage.this.packRootChangeControlPressed();
            }

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionPage.this.packRootChangeControlPressed();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void packRootChangeControlPressed() {
        ICProject cProject = this.chooseProject();
        if (cProject != null) {
            IPath path = cProject.getProject().getFullPath().makeRelative();
            this.projectName = path.toOSString();
            this.projectNameText.setText(this.projectName);
        }
    }

    private boolean validatePage() {
        this.currentCProject = null;
        String projectName = this.projectNameText.getText();
        if (projectName.length() == 0) {
            this.setErrorMessage(Messages.getString("ProjectSelectionPage.6"));
            return false;
        }
        Path path = new Path(projectName);
        if (path.segmentCount() != 1) {
            this.setErrorMessage(Messages.getString("ProjectSelectionPage.7"));
            return false;
        }
        IProject project = this.workspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.setErrorMessage(Messages.getString("ProjectSelectionPage.8"));
            return false;
        }
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) {
                this.currentCProject = CoreModel.getDefault().create(project);
                this.setErrorMessage(null);
                return true;
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.currentCProject = null;
        }
        this.setErrorMessage(Messages.getString("ProjectSelectionPage.9"));
        return false;
    }

    private ICProject chooseProject() {
        Object[] projects;
        try {
            projects = CoreModel.create((IWorkspaceRoot)this.workspaceRoot).getCProjects();
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
            projects = new ICProject[]{};
        }
        CElementLabelProvider labelProvider = new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.getString("ProjectSelectionPage.10"));
        dialog.setMessage(Messages.getString("ProjectSelectionPage.11"));
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.currentCProject});
        if (dialog.open() == 0) {
            return (ICProject)dialog.getFirstResult();
        }
        return null;
    }
}

