/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IBViewPart;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class IncludeBrowserUI {
    public static void open(IWorkbenchWindow window, ICElement input) {
        try {
            ITranslationUnit tu = IncludeBrowserUI.convertToTranslationUnit(input);
            if (tu != null) {
                IWorkbenchPage page = window.getActivePage();
                IBViewPart result = (IBViewPart)page.showView("org.eclipse.cdt.ui.includeBrowser");
                result.setInput(tu);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), IBMessages.OpenIncludeBrowserAction_label, null);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void open(ITextEditor editor, ITextSelection sel) {
        if (editor != null) {
            IWorkingCopy inputCElement = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
            IncludeBrowserUI.open(editor.getSite().getWorkbenchWindow(), (ICElement)inputCElement);
        }
    }

    private static ITranslationUnit convertToTranslationUnit(ICElement input) throws CoreException, InterruptedException {
        ITranslationUnit result = null;
        if (input instanceof IInclude) {
            result = IncludeBrowserUI.findTargetTranslationUnit((IInclude)input);
        }
        if (result == null && input instanceof ISourceReference) {
            result = ((ISourceReference)input).getTranslationUnit();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ITranslationUnit findTargetTranslationUnit(IInclude input) throws CoreException, InterruptedException {
        IIndex index;
        block3: {
            ITranslationUnit iTranslationUnit;
            ICProject project = input.getCProject();
            if (project == null) return null;
            index = CCorePlugin.getIndexManager().getIndex(project);
            index.acquireReadLock();
            try {
                IIndexFileLocation loc;
                IIndexInclude include = IndexUI.elementToInclude(index, input);
                if (include == null || (loc = include.getIncludesLocation()) == null) break block3;
                iTranslationUnit = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)loc, (ICProject)project);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                index.releaseReadLock();
                throw throwable;
            }
            index.releaseReadLock();
            return iTranslationUnit;
        }
        Object var5_8 = null;
        index.releaseReadLock();
        return null;
    }
}

