/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileManager;

public class ProfileVersioner
implements IProfileVersioner {
    public static final String CODE_FORMATTER_PROFILE_KIND = "CodeFormatterProfile";
    public static final int VERSION_1 = 1;
    public static final int CURRENT_VERSION = 1;

    public int getFirstVersion() {
        return 1;
    }

    public int getCurrentVersion() {
        return 1;
    }

    public String getProfileKind() {
        return CODE_FORMATTER_PROFILE_KIND;
    }

    public void update(ProfileManager.CustomProfile profile) {
        Map oldSettings = profile.getSettings();
        Map newSettings = ProfileVersioner.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(1);
        profile.setSettings(newSettings);
    }

    public static int getVersionStatus(ProfileManager.CustomProfile profile) {
        int version = profile.getVersion();
        if (version < 1) {
            return -1;
        }
        if (version > 1) {
            return 1;
        }
        return 0;
    }

    public static void updateAndComplete(ProfileManager.CustomProfile profile) {
        Map oldSettings = profile.getSettings();
        Map newSettings = ProfileVersioner.updateAndComplete(oldSettings, profile.getVersion());
        profile.setVersion(1);
        profile.setSettings(newSettings);
    }

    public static Map updateAndComplete(Map oldSettings, int version) {
        Map newSettings = FormatterProfileManager.getDefaultSettings();
        Iterator iter = oldSettings.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (!newSettings.containsKey(key) || (value = (String)oldSettings.get(key)) == null) continue;
            newSettings.put(key, value);
        }
        return newSettings;
    }
}

