/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public abstract class PDOMSearchQuery
implements ISearchQuery {
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURANCES = 7;
    protected PDOMSearchResult result = new PDOMSearchResult(this);
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;

    protected PDOMSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        try {
            if (scope == null) {
                this.projects = CoreModel.getDefault().getCModel().getCProjects();
            } else {
                HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
                int i = 0;
                while (i < scope.length) {
                    ICProject project = scope[i].getCProject();
                    if (project != null) {
                        projectMap.put(project.getElementName(), project);
                    }
                    ++i;
                }
                this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public String getLabel() {
        String type = (this.flags & 4) != 0 ? CSearchMessages.getString("PDOMSearch.query.refs.label") : ((this.flags & 1) != 0 ? CSearchMessages.getString("PDOMSearch.query.decls.label") : CSearchMessages.getString("PDOMSearch.query.defs.label"));
        return type;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void collectNames(IIndex index, IIndexName[] names) throws CoreException {
        int i = 0;
        while (i < names.length) {
            IIndexName name = names[i];
            if (!this.filterName(name)) {
                IASTFileLocation loc = name.getFileLocation();
                IIndexBinding binding = index.findBinding((IName)name);
                this.result.addMatch(new PDOMSearchMatch(index, binding, name, loc.getNodeOffset(), loc.getNodeLength()));
            }
            ++i;
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, this.flags);
            this.collectNames(index, names);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        PDOMSearchResult result = (PDOMSearchResult)this.getSearchResult();
        result.removeAll();
        try {
            IStatus iStatus;
            IIndex index = CCorePlugin.getIndexManager().getIndex(this.projects, 0);
            try {
                index.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            try {
                iStatus = this.runWithIndex(index, monitor);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                index.releaseReadLock();
                throw throwable;
            }
            index.releaseReadLock();
            return iStatus;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    protected abstract IStatus runWithIndex(IIndex var1, IProgressMonitor var2);
}

