/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;

public class PDOMSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private PDOMSearchQuery query;
    static /* synthetic */ Class class$0;

    public PDOMSearchResult(PDOMSearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    private String getFileName(IEditorPart editor) {
        ILocationProvider provider;
        Class<?> clazz;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            return fileInput.getFile().getLocation().toOSString();
        }
        if (input instanceof ExternalEditorInput) {
            ExternalEditorInput extInput = (ExternalEditorInput)input;
            return extInput.getStorage().getFullPath().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                if (storage.getFullPath() != null) {
                    return storage.getFullPath().toOSString();
                }
            }
            catch (CoreException coreException) {}
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            return path.toOSString();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((provider = (ILocationProvider)input.getAdapter((Class)clazz)) != null) {
            IPath path = provider.getPath((Object)input);
            return path.toOSString();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Path filename = new Path(this.getFileName(editor));
        if (filename != null && match instanceof PDOMSearchMatch) {
            return filename.equals((Object)IndexLocationFactory.getAbsolutePath((IIndexFileLocation)((PDOMSearchMatch)match).getLocation()));
        }
        return false;
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, String filename) throws CoreException {
        Path pfilename = new Path(filename);
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            if (pfilename.equals((Object)IndexLocationFactory.getAbsolutePath((IIndexFileLocation)((PDOMSearchElement)elements[i]).getLocation()))) {
                Match[] matches = result.getMatches(elements[i]);
                int j = 0;
                while (j < matches.length) {
                    if (matches[j] instanceof PDOMSearchMatch) {
                        list.add(matches[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        try {
            String filename = this.getFileName(editor);
            if (filename != null) {
                return this.computeContainedMatches(result, filename);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        try {
            String filename = file.getLocation().toOSString();
            return this.computeContainedMatches(result, filename);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            return new Match[0];
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IIndexName) {
            IIndexName name = (IIndexName)element;
            try {
                IIndexFileLocation location = name.getFile().getLocation();
                if (location.getFullPath() != null) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()));
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }
}

