/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;

public class PDOMSearchTextSelectionQuery
extends PDOMSearchQuery {
    private ITranslationUnit tu;
    private ITextSelection selection;

    public PDOMSearchTextSelectionQuery(ICElement[] scope, ITranslationUnit tu, ITextSelection selection, int flags) {
        super(scope, flags);
        this.tu = tu;
        this.selection = selection;
    }

    protected IStatus runWithIndex(final IIndex index, IProgressMonitor monitor) {
        return ASTProvider.getASTProvider().runOnAST((ICElement)this.tu, ASTProvider.WAIT_YES, monitor, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage language, IASTTranslationUnit ast) throws CoreException {
                IASTName[] names;
                if (ast != null && (names = language.getSelectedNames(ast, PDOMSearchTextSelectionQuery.this.selection.getOffset(), PDOMSearchTextSelectionQuery.this.selection.getLength())) != null) {
                    int i = 0;
                    while (i < names.length) {
                        IBinding binding = names[i].resolveBinding();
                        if (binding != null) {
                            PDOMSearchTextSelectionQuery.this.createMatches(index, binding);
                        }
                        ++i;
                    }
                }
                return Status.OK_STATUS;
            }
        });
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + " " + this.selection.getText();
    }
}

