/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PDOMSearchTreeContentProvider
implements ITreeContentProvider,
IPDOMSearchContentProvider {
    private TreeViewer viewer;
    private PDOMSearchResult result;
    private Map tree = new HashMap();

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.tree.get(parentElement);
        if (children == null) {
            return new Object[0];
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Iterator p = this.tree.keySet().iterator();
        while (p.hasNext()) {
            Object parent = p.next();
            Set children = (Set)this.tree.get(parent);
            if (!children.contains(element)) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.tree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren((Object)this.result);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.result = (PDOMSearchResult)((Object)newInput);
        this.tree.clear();
        if (this.result != null) {
            Object[] elements = this.result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insertSearchElement((PDOMSearchElement)elements[i]);
                ++i;
            }
        }
    }

    private void insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.tree.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.tree.put(parent, children);
        }
        children.add(child);
    }

    private void insertSearchElement(PDOMSearchElement element) {
        IFile[] files;
        IIndexFileLocation location = element.getLocation();
        if (location.getFullPath() != null) {
            files = new IFile[]{ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()))};
        } else {
            IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)element.getLocation());
            files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
        }
        boolean handled = false;
        if (files.length > 0) {
            int j = 0;
            while (j < files.length) {
                ICElement celement = CoreModel.getDefault().create(files[j]);
                if (celement != null) {
                    this.insertChild(celement, element);
                    this.insertCElement(celement);
                    handled = true;
                }
                ++j;
            }
        }
        if (!handled) {
            this.insertChild(element.getLocation(), element);
            this.insertChild((Object)this.result, element.getLocation());
        }
    }

    private void insertCElement(ICElement element) {
        if (element instanceof ICProject) {
            this.insertChild((Object)this.result, element);
        } else {
            ICElement parent = element.getParent();
            if (parent instanceof ISourceRoot && parent.getUnderlyingResource() instanceof IProject) {
                parent = parent.getParent();
            }
            this.insertChild(parent, element);
            this.insertCElement(parent);
        }
    }

    public void elementsChanged(Object[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                PDOMSearchElement element = (PDOMSearchElement)elements[i];
                if (this.result.getMatchCount(element) > 0) {
                    this.insertSearchElement(element);
                } else {
                    this.remove(element);
                }
                ++i;
            }
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                if (!PDOMSearchTreeContentProvider.this.viewer.getTree().isDisposed()) {
                    PDOMSearchTreeContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public void clear() {
        this.tree.clear();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PDOMSearchTreeContentProvider.this.viewer.refresh();
            }
        });
    }

    protected void remove(Object element) {
        Object parent = this.getParent(element);
        if (parent == null) {
            return;
        }
        Set siblings = (Set)this.tree.get(parent);
        siblings.remove(element);
        if (siblings.isEmpty()) {
            this.remove(parent);
            this.tree.remove(parent);
        }
    }
}

