/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.CBraceRule;
import org.eclipse.cdt.internal.ui.text.COperatorRule;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.NumberRule;
import org.eclipse.cdt.internal.ui.text.util.CWhitespaceDetector;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class CCodeScanner
extends AbstractCScanner {
    private static String[] fgTokenProperties = new String[]{"c_keyword", "c_type", "c_operators", "c_braces", "c_numbers", "c_default"};
    private ICLanguageKeywords fKeywords;

    public CCodeScanner(IColorManager manager, IPreferenceStore store, ICLanguageKeywords keywords) {
        super(manager, store);
        this.fKeywords = keywords;
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new CWhitespaceDetector()));
        Token token = this.getToken("c_default");
        WordRule wordRule = new WordRule((IWordDetector)new CWordDetector(), (IToken)token);
        token = this.getToken("c_keyword");
        String[] keywords = this.fKeywords.getKeywords();
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("c_type");
        String[] types = this.fKeywords.getBuiltinTypes();
        int i2 = 0;
        while (i2 < types.length) {
            wordRule.addWord(types[i2], (IToken)token);
            ++i2;
        }
        rules.add(wordRule);
        token = this.getToken("c_numbers");
        NumberRule numberRule = new NumberRule((IToken)token);
        rules.add(numberRule);
        token = this.getToken("c_operators");
        COperatorRule opRule = new COperatorRule((IToken)token);
        rules.add(opRule);
        token = this.getToken("c_braces");
        CBraceRule braceRule = new CBraceRule((IToken)token);
        rules.add(braceRule);
        this.setDefaultReturnToken((IToken)this.getToken("c_default"));
        return rules;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }
}

