/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class PreprocessorRule
extends WordRule {
    private StringBuffer fBuffer = new StringBuffer();
    private IToken fMalformedToken;

    public PreprocessorRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED);
    }

    public PreprocessorRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public PreprocessorRule(IWordDetector detector, IToken defaultToken, IToken malformedToken) {
        super(detector, defaultToken);
        this.fMalformedToken = malformedToken;
    }

    public void addWord(String word, IToken token) {
        if (word.charAt(0) == '#') {
            word = word.substring(1);
        }
        super.addWord(word, token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        int nCharsToRollback = 0;
        boolean hashSignDetected = false;
        do {
            c = scanner.read();
            ++nCharsToRollback;
        } while (c == 32 || c == 9);
        if (c == 35) {
            hashSignDetected = true;
        } else if (c == 37) {
            c = scanner.read();
            ++nCharsToRollback;
            if (c == 58) {
                hashSignDetected = true;
            }
        } else if (c == 63) {
            c = scanner.read();
            ++nCharsToRollback;
            if (c == 63) {
                c = scanner.read();
                ++nCharsToRollback;
                if (c == 61) {
                    hashSignDetected = true;
                }
            }
        }
        if (hashSignDetected) {
            IToken token;
            while ((c = scanner.read()) == 32 || c == 9) {
            }
            this.fBuffer.setLength(0);
            if (c != 35) {
                if (this.fDetector.isWordStart((char)c)) {
                    do {
                        this.fBuffer.append((char)c);
                    } while (this.fDetector.isWordPart((char)(c = scanner.read())));
                }
                scanner.unread();
            }
            if ((token = (IToken)this.fWords.get(this.fBuffer.toString())) != null) {
                return token;
            }
            if (this.fMalformedToken != null) {
                while ((c = scanner.read()) != -1) {
                }
                return this.fMalformedToken;
            }
            return this.fDefaultToken;
        }
        int i = 0;
        while (i < nCharsToRollback) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }
}

