/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public abstract class ParsingBasedProposalComputer
implements ICompletionProposalComputer {
    private String fErrorMessage = null;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        try {
            if (context instanceof CContentAssistInvocationContext) {
                CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
                IASTCompletionNode completionNode = cContext.getCompletionNode();
                if (completionNode == null) {
                    return Collections.EMPTY_LIST;
                }
                String prefix = completionNode.getPrefix();
                if (prefix == null) {
                    prefix = cContext.computeIdentifierPrefix().toString();
                }
                return this.computeCompletionProposals(cContext, completionNode, prefix);
            }
        }
        catch (Throwable e) {
            this.fErrorMessage = e.toString();
            CUIPlugin.getDefault().log(e);
        }
        return Collections.EMPTY_LIST;
    }

    protected abstract List computeCompletionProposals(CContentAssistInvocationContext var1, IASTCompletionNode var2, String var3) throws CoreException;

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ArrayList proposals = this.computeCompletionProposals(context, monitor);
        proposals = new ArrayList(new LinkedHashSet(proposals));
        ArrayList<IContextInformation> result = new ArrayList<IContextInformation>();
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            ICompletionProposal proposal = (ICompletionProposal)it.next();
            IContextInformation contextInformation = proposal.getContextInformation();
            if (contextInformation == null) continue;
            result.add(contextInformation);
        }
        return result;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
        this.fErrorMessage = null;
    }
}

