/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.text.folding.FoldingMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.folding.ICFoldingPreferenceBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DefaultCFoldingPreferenceBlock
implements ICFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    protected OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    protected Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            String key = (String)DefaultCFoldingPreferenceBlock.this.fCheckBoxes.get(button);
            DefaultCFoldingPreferenceBlock.this.fOverlayStore.setValue(key, button.getSelection());
            DefaultCFoldingPreferenceBlock.this.updateEnablement(key);
        }
    };
    private Button fInactiveCodeFoldingCheckBox;

    public DefaultCFoldingPreferenceBlock() {
        this.fStore = CUIPlugin.getDefault().getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_macros"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_functions"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_methods"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_structures"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_headers"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_inactive"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_preprocessor_enabled"));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.addCheckBox(inner, FoldingMessages.DefaultCFoldingPreferenceBlock_preprocessor_enabled, "editor_folding_preprocessor_enabled", 1);
        ControlFactory.createEmptySpace(inner);
        Group group = ControlFactory.createGroup(inner, FoldingMessages.DefaultCFoldingPreferenceBlock_title, 1);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_macros, "editor_folding_default_macros", 0);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_functions, "editor_folding_default_functions", 0);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_methods, "editor_folding_default_methods", 0);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_structures, "editor_folding_default_structures", 0);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_comments, "editor_folding_default_comments", 0);
        this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_headers, "editor_folding_default_headers", 0);
        this.fInactiveCodeFoldingCheckBox = this.addCheckBox((Composite)group, FoldingMessages.DefaultCFoldingPreferenceBlock_inactive_code, "editor_folding_default_inactive", 0);
        return inner;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        Iterator it = this.fCheckBoxes.keySet().iterator();
        while (it.hasNext()) {
            Button b = (Button)it.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
            this.updateEnablement(key);
        }
    }

    protected void updateEnablement(String key) {
        if ("editor_folding_preprocessor_enabled".equals(key)) {
            this.fInactiveCodeFoldingCheckBox.setEnabled(this.fOverlayStore.getBoolean(key));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

