/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractBinaryParserPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class BinaryParserBlock
extends AbstractBinaryParserPage {
    private static final int DEFAULT_HEIGHT = 160;
    private static final String PREFIX = "BinaryParserBlock";
    private static final String LABEL = "BinaryParserBlock.label";
    private static final String DESC = "BinaryParserBlock.desc";
    private static final String ATTR_FILTER = "filter";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_NAME_VISIBILITY = "visibility";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_PRIVATE = "private";
    protected CheckedListDialogField binaryList;
    protected Map configMap;
    protected List initialSelected;

    public BinaryParserBlock() {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
        String[] buttonLabels = new String[]{CUIMessages.getString("BinaryParserBlock.button.up"), CUIMessages.getString("BinaryParserBlock.button.down")};
        IListAdapter listAdapter = new IListAdapter(){

            public void customButtonPressed(ListDialogField field, int index) {
            }

            public void selectionChanged(ListDialogField field) {
                BinaryParserBlock.this.handleBinaryParserChanged();
            }

            public void doubleClicked(ListDialogField field) {
            }
        };
        this.binaryList = new CheckedListDialogField(listAdapter, buttonLabels, (IBaseLabelProvider)new BinaryParserLabelProvider()){

            protected int getListStyle() {
                int style = super.getListStyle();
                return style & 0xFFFFFFFD;
            }
        };
        this.binaryList.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (BinaryParserBlock.this.getContainer() != null) {
                    BinaryParserBlock.this.getContainer().updateContainer();
                    BinaryParserBlock.this.handleBinaryParserChanged();
                }
            }
        });
        this.binaryList.setLabelText(CUIMessages.getString("BinaryParserBlock.binaryParser"));
        this.binaryList.setUpButtonIndex(0);
        this.binaryList.setDownButtonIndex(1);
        this.initializeParserList();
    }

    private void initializeParserList() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            this.configMap = new HashMap(exts.length);
            int i = 0;
            while (i < exts.length) {
                if (this.isExtensionVisible(exts[i])) {
                    this.configMap.put(exts[i].getUniqueIdentifier(), new BinaryParserConfiguration(exts[i]));
                }
                ++i;
            }
        }
    }

    private boolean isExtensionVisible(IExtension ext) {
        int i = 0;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        if (i < elements.length) {
            IConfigurationElement[] children = elements[i].getChildren(ATTR_FILTER);
            int j = 0;
            while (j < children.length) {
                String value;
                String name = children[j].getAttribute(ATTR_NAME);
                if (name != null && name.equals(ATTR_NAME_VISIBILITY) && (value = children[j].getAttribute(ATTR_VALUE)) != null && value.equals(ATTR_VALUE_PRIVATE)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = ControlFactory.createComposite(parent, 1);
        ((GridData)composite.getLayoutData()).horizontalAlignment = 768;
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.newproj_parser_binary");
        Composite listComposite = ControlFactory.createComposite(composite, 1);
        LayoutUtil.doDefaultLayout(listComposite, new DialogField[]{this.binaryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.binaryList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(15);
        this.binaryList.setButtonsMinWidth(buttonBarWidth);
        Composite parserGroup = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.heightHint = converter.convertHorizontalDLUsToPixels(160);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        parserGroup.setLayoutData((Object)gd);
        this.setCompositeParent(parserGroup);
        this.handleBinaryParserChanged();
        parent.layout(true);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CUIMessages.getString("BinaryParserBlock.settingBinaryParser"), 2);
        List parsers = this.binaryList.getElements();
        final ArrayList selected = new ArrayList();
        int i = 0;
        while (i < parsers.size()) {
            if (this.binaryList.isChecked(parsers.get(i))) {
                selected.add(parsers.get(i));
            }
            ++i;
        }
        if (selected != null) {
            if (this.getContainer().getProject() != null) {
                ICDescriptorOperation op = new ICDescriptorOperation(){

                    public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                        int i;
                        if (BinaryParserBlock.this.initialSelected == null || !selected.equals(BinaryParserBlock.this.initialSelected)) {
                            descriptor.remove("org.eclipse.cdt.core.BinaryParser");
                            i = 0;
                            while (i < selected.size()) {
                                descriptor.create("org.eclipse.cdt.core.BinaryParser", ((BinaryParserConfiguration)selected.get(i)).getID());
                                ++i;
                            }
                        }
                        monitor.worked(1);
                        i = 0;
                        while (i < selected.size()) {
                            ICOptionPage page = BinaryParserBlock.this.getBinaryParserPage(((BinaryParserConfiguration)selected.get(i)).getID());
                            if (page != null && page.getControl() != null) {
                                page.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            ++i;
                        }
                    }
                };
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.getContainer().getProject(), op, monitor);
            } else {
                Preferences store;
                if (!(this.initialSelected != null && selected.equals(this.initialSelected) || (store = this.getContainer().getPreferences()) == null)) {
                    store.setValue("binaryparser", this.arrayToString(selected.toArray()));
                }
                monitor.worked(1);
                i = 0;
                while (i < selected.size()) {
                    ICOptionPage page = this.getBinaryParserPage(((BinaryParserConfiguration)selected.get(i)).getID());
                    if (page != null && page.getControl() != null) {
                        page.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    ++i;
                }
            }
            this.initialSelected = selected;
        }
        monitor.done();
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        ArrayList elements = new ArrayList();
        if (this.getContainer().getProject() != null) {
            try {
                ICExtensionReference[] ref = CCorePlugin.getDefault().getBinaryParserExtensions(this.getContainer().getProject());
                this.initialSelected = new ArrayList(ref.length);
                int i = 0;
                while (i < ref.length) {
                    if (this.configMap.get(ref[i].getID()) != null) {
                        this.initialSelected.add(this.configMap.get(ref[i].getID()));
                        elements.add(this.configMap.get(ref[i].getID()));
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            Iterator iter = this.configMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (elements.contains(entry.getValue())) continue;
                elements.add(entry.getValue());
            }
            this.binaryList.setElements(elements);
            if (this.initialSelected != null) {
                this.binaryList.setCheckedElements(this.initialSelected);
            }
        }
        if (this.initialSelected == null) {
            Preferences store = this.getContainer().getPreferences();
            String id = null;
            if (store != null) {
                id = store.getString("binaryparser");
            }
            if (id != null && id.length() > 0) {
                String[] ids = this.parseStringToArray(id);
                this.initialSelected = new ArrayList(ids.length);
                int i = 0;
                while (i < ids.length) {
                    if (this.configMap.get(ids[i]) != null) {
                        this.initialSelected.add(this.configMap.get(ids[i]));
                        elements.add(this.configMap.get(ids[i]));
                    }
                    ++i;
                }
            }
            Iterator iter = this.configMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (elements.contains(entry.getValue())) continue;
                elements.add(entry.getValue());
            }
            this.binaryList.setElements(elements);
            if (this.initialSelected != null) {
                this.binaryList.setCheckedElements(this.initialSelected);
            }
            this.initialSelected = null;
        }
    }

    private String arrayToString(Object[] array) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            buf.append(array[i].toString()).append(';');
            ++i;
        }
        return buf.toString();
    }

    private String[] parseStringToArray(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    public void performDefaults() {
        String id = null;
        List selected = this.binaryList.getCheckedElements();
        int i = 0;
        while (i < selected.size()) {
            ICOptionPage page = this.getBinaryParserPage(((BinaryParserConfiguration)selected.get(i)).getID());
            if (page != null) {
                page.performDefaults();
            }
            ++i;
        }
        Preferences store = this.getContainer().getPreferences();
        if (store != null) {
            id = this.getContainer().getProject() != null ? store.getString("binaryparser") : store.getDefaultString("binaryparser");
        }
        selected.clear();
        if (id != null) {
            String[] ids = this.parseStringToArray(id);
            int i2 = 0;
            while (i2 < ids.length) {
                if (this.configMap.get(ids[i2]) != null) {
                    selected.add(this.configMap.get(ids[i2]));
                }
                ++i2;
            }
        }
        this.binaryList.setCheckedElements(selected);
        this.binaryList.getTableViewer().setSelection((ISelection)new StructuredSelection(selected.get(0)), true);
        this.handleBinaryParserChanged();
        this.getContainer().updateContainer();
    }

    protected String getCurrentBinaryParserID() {
        List list = this.binaryList.getSelectedElements();
        if (list.size() > 0) {
            BinaryParserConfiguration selected = (BinaryParserConfiguration)list.get(0);
            return selected.getID();
        }
        return null;
    }

    protected String[] getBinaryParserIDs() {
        return this.configMap.keySet().toArray(new String[this.configMap.keySet().size()]);
    }

    protected class BinaryParserConfiguration {
        IExtension fExtension;

        public BinaryParserConfiguration(IExtension extension) {
            this.fExtension = extension;
        }

        public String getID() {
            return this.fExtension.getUniqueIdentifier();
        }

        public String getName() {
            return this.fExtension.getLabel();
        }

        public String toString() {
            return this.fExtension.getUniqueIdentifier();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BinaryParserConfiguration) {
                return this.getID().equals(((BinaryParserConfiguration)obj).getID());
            }
            return super.equals(obj);
        }
    }

    protected class BinaryParserLabelProvider
    extends LabelProvider {
        protected BinaryParserLabelProvider() {
        }

        public String getText(Object element) {
            return ((BinaryParserConfiguration)element).getName();
        }
    }
}

