/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.FormBrowser;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplatesChoiceWizard;
import org.eclipse.cdt.ui.templateengine.WizardNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class TemplateListSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener {
    private String labelText;
    private FormBrowser descriptionBrowser;
    private TreeViewer wizardSelectionTreeViewer = null;
    private TableViewer wizardSelectionTableViewer = null;
    private StructuredViewer wizardSelectionViewer = null;
    private TemplatesChoiceWizard parentWizard;
    private Template[] templates;

    public TemplateListSelectionPage(TemplatesChoiceWizard parentWizard) {
        super("Template Selection");
        this.setTitle(parentWizard.getListSelectionTitle());
        this.setDescription(parentWizard.getListSelectionDescription());
        this.labelText = parentWizard.getListSelectionLabel();
        this.descriptionBrowser = new FormBrowser();
        this.descriptionBrowser.setText("");
        this.parentWizard = parentWizard;
    }

    public void createDescriptionIn(Composite composite) {
        this.descriptionBrowser.createControl(composite);
        Control c = this.descriptionBrowser.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        c.setLayoutData((Object)gd);
    }

    public String getLabel() {
        return this.labelText;
    }

    public void setDescriptionText(String text) {
        this.descriptionBrowser.setText(text);
    }

    public void setDescriptionEnabled(boolean enabled) {
        Control control = this.descriptionBrowser.getControl();
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void moveToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(this.getLabel());
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        SashForm sashForm = new SashForm(container, 512);
        gd = new GridData(1808);
        gd.widthHint = 300;
        gd.minimumHeight = 230;
        sashForm.setLayoutData((Object)gd);
        boolean useTree = this.parentWizard.showTemplatesInTreeView();
        if (useTree) {
            this.wizardSelectionTreeViewer = new TreeViewer((Composite)sashForm, 2048);
            this.wizardSelectionTreeViewer.setContentProvider((IContentProvider)this.parentWizard);
            this.wizardSelectionTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TemplateListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TemplateListSelectionPage.this.wizardSelectionTreeViewer, TemplateListSelectionPage.this.wizardSelectionTreeViewer.getSelection()));
                    TemplateListSelectionPage.this.moveToNextPage();
                }
            });
            this.wizardSelectionTreeViewer.setInput((Object)this.templates);
            this.wizardSelectionTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.wizardSelectionTreeViewer.getTree().setData("name", (Object)"templates");
            this.wizardSelectionViewer = this.wizardSelectionTreeViewer;
        } else {
            this.wizardSelectionTableViewer = new TableViewer((Composite)sashForm, 2048);
            this.wizardSelectionTableViewer.setContentProvider((IContentProvider)this.parentWizard);
            this.wizardSelectionTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    TemplateListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TemplateListSelectionPage.this.wizardSelectionTableViewer, TemplateListSelectionPage.this.wizardSelectionTableViewer.getSelection()));
                    TemplateListSelectionPage.this.moveToNextPage();
                }
            });
            this.wizardSelectionTableViewer.setInput((Object)this.templates);
            this.wizardSelectionTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.wizardSelectionTableViewer.getTable().setData("name", (Object)"templates");
            this.wizardSelectionViewer = this.wizardSelectionTableViewer;
        }
        this.wizardSelectionViewer.getControl().setData(".uid", (Object)"wizardSelectionViewer");
        this.createDescriptionIn((Composite)sashForm);
        sashForm.setWeights(new int[]{75, 25});
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Template currentWizardSelection = null;
        Object selectedObject = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext() && (selectedObject = iter.next()) instanceof Template) {
            currentWizardSelection = selectedObject;
        }
        if (currentWizardSelection == null) {
            this.setDescriptionText(this.parentWizard.getDescription(selectedObject));
            this.setSelectedNode(null);
            return;
        }
        Template finalSelection = currentWizardSelection;
        this.setSelectedNode(new WizardNode(this, finalSelection));
        this.setDescriptionText(this.parentWizard.getDescription((Object)finalSelection));
        this.getContainer().updateButtons();
    }

    public Template getTemplate() {
        IWizardNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            return ((WizardNode)selectedNode).getTemplate();
        }
        return null;
    }

    public IWizardPage getNextPage(boolean shouldCreate) {
        if (!shouldCreate) {
            return super.getNextPage();
        }
        IWizardNode selectedNode = this.getSelectedNode();
        selectedNode.dispose();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            super.setSelectedNode(null);
            return null;
        }
        if (shouldCreate) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    public boolean canFlipToNextPage() {
        IStructuredSelection ssel = (IStructuredSelection)this.wizardSelectionViewer.getSelection();
        return ssel != null && !ssel.isEmpty() && ssel.getFirstElement() instanceof Template;
    }

    public void setVisible(boolean visible) {
        Template[] templates;
        if (visible && this.templatesHaveChanged(templates = this.parentWizard.getTemplates())) {
            this.templates = templates;
            this.wizardSelectionViewer.setInput((Object)templates);
            this.wizardSelectionViewer.refresh();
            if (this.wizardSelectionTreeViewer != null) {
                this.wizardSelectionTreeViewer.expandAll();
            }
            if (this.wizardSelectionTableViewer != null) {
                this.wizardSelectionTableViewer.setSelection((ISelection)new StructuredSelection(this.wizardSelectionTableViewer.getElementAt(0)), true);
            }
            if (this.wizardSelectionTreeViewer != null) {
                this.wizardSelectionTreeViewer.setSelection((ISelection)new StructuredSelection(this.wizardSelectionTreeViewer.getTree().getItem(0).getData()), true);
            }
        }
        super.setVisible(visible);
        if (visible) {
            if (this.wizardSelectionTreeViewer != null) {
                this.wizardSelectionTreeViewer.getTree().setFocus();
            }
            if (this.wizardSelectionTableViewer != null) {
                this.wizardSelectionTableViewer.getTable().setFocus();
            }
        }
    }

    private boolean templatesHaveChanged(Template[] newTemplates) {
        boolean changed = false;
        if (newTemplates != null && this.templates != null && newTemplates.length == this.templates.length) {
            int i = 0;
            while (i < this.templates.length) {
                if (!newTemplates[i].getTemplateInfo().equals((Object)this.templates[i].getTemplateInfo())) {
                    changed = true;
                    break;
                }
                ++i;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    Map getDataInPreviousPages() {
        return this.parentWizard.getAllDataInNonTemplatePages();
    }

    public IWizardDataPage[] getPagesAfterTemplatePages() {
        return this.parentWizard.getPagesAfterTemplatePages();
    }

    public IWizardDataPage[] getPagesAfterTemplateSelection() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.parentWizard.getPagesAfterTemplateSelectionWithExtraPages(this.getTemplate());
    }

    public void adjustTemplateValues(Template template) {
        this.parentWizard.adjustTemplateValues(template);
    }
}

