/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.util.Strings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;

public abstract class TranslationUnitContext
extends DocumentTemplateContext {
    private final ITranslationUnit fTranslationUnit;
    protected boolean fForceEvaluation;
    protected final boolean fIsManaged;

    protected TranslationUnitContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ITranslationUnit translationUnit) {
        super(type, document, completionOffset, completionLength);
        this.fTranslationUnit = translationUnit;
        this.fIsManaged = false;
    }

    protected TranslationUnitContext(TemplateContextType type, IDocument document, Position completionPosition, ITranslationUnit translationUnit) {
        super(type, document, completionPosition);
        this.fTranslationUnit = translationUnit;
        this.fIsManaged = true;
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().startsWith(key);
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public final ITranslationUnit getTranslationUnit() {
        return this.fTranslationUnit;
    }

    public ICElement findEnclosingElement(int elementType) {
        if (this.fTranslationUnit == null) {
            return null;
        }
        try {
            ICElement element = this.fTranslationUnit.getElementAtOffset(this.getStart());
            while (element != null && element.getElementType() != elementType) {
                element = element.getParent();
            }
            return element;
        }
        catch (CModelException cModelException) {
            return null;
        }
    }

    public void setForceEvaluation(boolean evaluate) {
        this.fForceEvaluation = evaluate;
    }

    protected ICProject getCProject() {
        ITranslationUnit translationUnit = this.getTranslationUnit();
        ICProject project = translationUnit == null ? null : translationUnit.getCProject();
        return project;
    }

    protected int getIndentationLevel() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            ICProject project = this.getCProject();
            return Strings.computeIndent(lineContent, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }
}

