/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;

class ReferenceVisitor
extends ASTVisitor {
    private ArrayList fReferences = new ArrayList();
    private int fOffset;
    private int fEndOffset;
    private String fFileName;

    ReferenceVisitor(String fileName, int offset, int length) {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.fFileName = fileName;
        this.fOffset = offset;
        this.fEndOffset = offset + length;
    }

    public IASTName[] getReferences() {
        return this.fReferences.toArray(new IASTName[this.fReferences.size()]);
    }

    public int visit(IASTName name) {
        if (name.isReference()) {
            IASTFileLocation loc = name.getFileLocation();
            if (!loc.getFileName().equals(this.fFileName)) {
                return 1;
            }
            int offset = loc.getNodeOffset();
            if (this.fOffset <= offset && offset + loc.getNodeLength() <= this.fEndOffset) {
                this.fReferences.add(name);
            }
        }
        return super.visit(name);
    }

    public int visit(IASTDeclaration declaration) {
        IASTFileLocation loc = declaration.getFileLocation();
        if (loc != null) {
            if (!loc.getFileName().equals(this.fFileName)) {
                return 1;
            }
            int offset = loc.getNodeOffset();
            if (offset + loc.getNodeLength() <= this.fOffset || this.fEndOffset <= offset) {
                return 1;
            }
        }
        return 3;
    }
}

