/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.internal.ui.help.CHelpBook;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CHelpProvider
implements ICHelpProvider {
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.HelpInfo";
    private static final String ELEMENT_NAME = "helpInfo";
    private static final String ATTRIB_FILE = "file";
    private static final String NODE_HEAD = "documentation";
    private static final String NODE_BOOK = "helpBook";
    ICHelpBook[] hbs = null;

    public ICHelpBook[] getCHelpBooks() {
        return this.hbs;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        int i = 0;
        while (i < helpBooks.length) {
            IFunctionSummary fs;
            if (helpBooks[i] instanceof CHelpBook && (fs = ((CHelpBook)helpBooks[i]).getFunctionInfo(context, name)) != null) {
                return fs;
            }
            ++i;
        }
        return null;
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        ArrayList<ICHelpResourceDescriptor> lst = new ArrayList<ICHelpResourceDescriptor>();
        int i = 0;
        while (i < helpBooks.length) {
            ICHelpResourceDescriptor hrd;
            if (helpBooks[i] instanceof CHelpBook && (hrd = ((CHelpBook)helpBooks[i]).getHelpResources(context, name)) != null) {
                lst.add(hrd);
            }
            ++i;
        }
        if (lst.size() > 0) {
            return lst.toArray(new ICHelpResourceDescriptor[lst.size()]);
        }
        return null;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String prefix) {
        ArrayList lst = new ArrayList();
        int i = 0;
        while (i < helpBooks.length) {
            List fs;
            if (helpBooks[i] instanceof CHelpBook && (fs = ((CHelpBook)helpBooks[i]).getMatchingFunctions(context, prefix)) != null) {
                lst.addAll(fs);
            }
            ++i;
        }
        if (lst.size() > 0) {
            return lst.toArray(new IFunctionSummary[lst.size()]);
        }
        return null;
    }

    public void initialize() {
        this.loadExtensions();
        System.out.println();
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return;
        }
        ArrayList chbl = new ArrayList();
        int i = 0;
        while (i < extensions.length) {
            String pluginId = extensions[i].getNamespaceIdentifier();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME)) {
                    this.loadFile(elements[k], chbl, pluginId);
                }
                ++k;
            }
            ++i;
        }
        if (chbl.size() > 0) {
            this.hbs = chbl.toArray(new ICHelpBook[chbl.size()]);
        }
    }

    private void loadFile(IConfigurationElement el, ArrayList chbl, String pluginId) {
        String fname = el.getAttribute(ATTRIB_FILE);
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        URL x = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(fname), null);
        if (x == null) {
            return;
        }
        try {
            x = FileLocator.toFileURL((URL)x);
        }
        catch (IOException iOException) {
            return;
        }
        fname = x.getPath();
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        Document doc = null;
        try {
            FileInputStream stream = new FileInputStream(fname);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            InputSource src = new InputSource(reader);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(src);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        Element e = doc.getDocumentElement();
        if (NODE_HEAD.equals(e.getNodeName())) {
            NodeList list = e.getChildNodes();
            int j = 0;
            while (j < list.getLength()) {
                Node node = list.item(j);
                if (node.getNodeType() == 1 && NODE_BOOK.equals(node.getNodeName())) {
                    chbl.add(new CHelpBook((Element)node));
                }
                ++j;
            }
        }
    }
}

