/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.ui.language.LanguageMappingWidget;
import org.eclipse.cdt.internal.ui.language.ProjectContentTypeMappingDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ProjectLanguageMappingWidget
extends LanguageMappingWidget {
    static final String CONTENT_TYPE_KEY_DELIMITER = "::";
    private static final String ALL_CONFIGURATIONS = "";
    private static final int CONFIGURATION_COLUMN = 0;
    private static final int CONTENT_TYPE_COLUMN = 1;
    private static final int LANGUAGE_COLUMN = 2;
    private Map fConfigurationContentTypeMappings;
    static /* synthetic */ Class class$0;

    public void setMappings(Map contentTypeMappings) {
        this.fConfigurationContentTypeMappings = contentTypeMappings;
    }

    public Map getContentTypeMappings() {
        return this.fConfigurationContentTypeMappings;
    }

    public Composite createContents(Composite parent, String description) {
        this.fContents = new Composite(parent, 0);
        this.fContents.setLayout((Layout)new GridLayout(2, false));
        if (description != null) {
            this.createHeader(parent, description);
        }
        Composite tableParent = new Composite(this.fContents, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new Table(tableParent, 68098);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.fTable.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = PreferencesMessages.ProjectLanguagesPropertyPage_mappingTableTitle;
            }
        });
        this.fTable.setToolTipText(PreferencesMessages.ProjectLanguagesPropertyPage_mappingTableTitle);
        TableColumn configurationColumn = new TableColumn(this.fTable, 16384);
        configurationColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_configurationColumn);
        TableColumn contentTypeColumn = new TableColumn(this.fTable, 16384);
        contentTypeColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_contentTypeColumn);
        TableColumn languageColumn = new TableColumn(this.fTable, 16384);
        languageColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_languageColumn);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)configurationColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        layout.setColumnData((Widget)contentTypeColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        layout.setColumnData((Widget)languageColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        tableParent.setLayout((Layout)layout);
        Composite buttons = new Composite(this.fContents, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1, 1, false, false));
        Button addButton = new Button(buttons, 8);
        addButton.setLayoutData((Object)new GridData(4, 1, true, false));
        addButton.setText(PreferencesMessages.ProjectLanguagesPropertyPage_addMappingButton);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IAdaptable iAdaptable = ProjectLanguageMappingWidget.this.getElement();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IProject project = (IProject)iAdaptable.getAdapter((Class)clazz);
                ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, false);
                ICConfigurationDescription[] configurations = description.getConfigurations();
                ProjectContentTypeMappingDialog dialog = new ProjectContentTypeMappingDialog(ProjectLanguageMappingWidget.this.fContents.getShell(), configurations);
                dialog.setContentTypeFilter(ProjectLanguageMappingWidget.this.createContentTypeFilter(ProjectLanguageMappingWidget.this.fConfigurationContentTypeMappings));
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    TreeMap<String, String> contentTypeMappings;
                    String contentType = dialog.getContentTypeID();
                    String language = dialog.getLanguageID();
                    String configuration = dialog.getConfigurationID();
                    if (configuration == null) {
                        configuration = ProjectLanguageMappingWidget.ALL_CONFIGURATIONS;
                    }
                    if ((contentTypeMappings = (TreeMap<String, String>)ProjectLanguageMappingWidget.this.fConfigurationContentTypeMappings.get(configuration)) == null) {
                        contentTypeMappings = new TreeMap<String, String>();
                        ProjectLanguageMappingWidget.this.fConfigurationContentTypeMappings.put(configuration, contentTypeMappings);
                    }
                    contentTypeMappings.put(contentType, language);
                    ProjectLanguageMappingWidget.this.setChanged(true);
                    IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                    ProjectLanguageMappingWidget.this.fAffectedContentTypes.add(contentTypeManager.getContentType(contentType));
                    ProjectLanguageMappingWidget.this.refreshMappings();
                }
            }
        });
        Button removeButton = new Button(buttons, 8);
        removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        removeButton.setText(PreferencesMessages.ProjectLanguagesPropertyPage_removeMappingButton);
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = ProjectLanguageMappingWidget.this.fTable.getSelection();
                int i = 0;
                while (i < selection.length) {
                    LanguageTableData data = (LanguageTableData)selection[i].getData();
                    String contentType = data.contentTypeId;
                    String configurationId = data.configuration == null ? ProjectLanguageMappingWidget.ALL_CONFIGURATIONS : data.configuration.getId();
                    Map contentTypeMappings = (Map)ProjectLanguageMappingWidget.this.fConfigurationContentTypeMappings.get(configurationId);
                    if (contentTypeMappings != null) {
                        contentTypeMappings.remove(contentType);
                    }
                    IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                    ProjectLanguageMappingWidget.this.fAffectedContentTypes.add(contentTypeManager.getContentType(contentType));
                    ++i;
                }
                if (selection.length > 0) {
                    ProjectLanguageMappingWidget.this.setChanged(true);
                }
                ProjectLanguageMappingWidget.this.refreshMappings();
            }
        });
        this.refreshMappings();
        return this.fContents;
    }

    private Set createContentTypeFilter(Map mappings) {
        HashSet<String> filter = new HashSet<String>();
        Iterator configurationContentTypeMappings = mappings.entrySet().iterator();
        while (configurationContentTypeMappings.hasNext()) {
            Map.Entry entry = configurationContentTypeMappings.next();
            String configuration = (String)entry.getKey();
            Iterator contentTypeMappings = ((Map)entry.getValue()).entrySet().iterator();
            while (contentTypeMappings.hasNext()) {
                Map.Entry contentTypeEntry = contentTypeMappings.next();
                String contentType = (String)contentTypeEntry.getKey();
                filter.add(ProjectLanguageMappingWidget.createFilterKey(configuration, contentType));
            }
        }
        return filter;
    }

    public void refreshMappings() {
        if (this.fTable == null) {
            return;
        }
        this.fTable.removeAll();
        Iterator mappings = this.fConfigurationContentTypeMappings.entrySet().iterator();
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject project = (IProject)iAdaptable.getAdapter((Class)clazz);
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project, false);
        while (mappings.hasNext()) {
            Map.Entry configurationEntry = mappings.next();
            String configurationId = (String)configurationEntry.getKey();
            Iterator contentTypeMappings = ((Map)configurationEntry.getValue()).entrySet().iterator();
            while (contentTypeMappings.hasNext()) {
                Map.Entry entry = contentTypeMappings.next();
                TableItem item = new TableItem(this.fTable, 0);
                String contentType = (String)entry.getKey();
                String contentTypeName = contentTypeManager.getContentType(contentType).getName();
                String languageId = (String)entry.getValue();
                String languageName = LanguageManager.getInstance().getLanguage(languageId).getName();
                ICConfigurationDescription configuration = description.getConfigurationById(configurationId);
                item.setData((Object)new LanguageTableData(configuration, contentType, languageId));
                if (configuration == null) {
                    item.setText(0, PreferencesMessages.ContentTypeMappingsDialog_allConfigurations);
                } else {
                    item.setText(0, configuration.getName());
                }
                if (this.fOverriddenContentTypes.contains(contentType)) {
                    item.setText(1, Messages.format(PreferencesMessages.ProjectLanguagesPropertyPage_overriddenContentType, contentTypeName));
                    item.setFont(this.fOverriddenFont);
                } else {
                    item.setText(1, contentTypeName);
                }
                item.setText(2, languageName);
            }
        }
        if (this.fChild != null) {
            HashSet overrides = new HashSet(this.createWorkspaceContentTypeFilter(this.fConfigurationContentTypeMappings));
            this.fChild.setOverriddenContentTypes(overrides);
            this.fChild.refreshMappings();
        }
    }

    private Set createWorkspaceContentTypeFilter(Map configurationContentTypeMappings) {
        Map contentTypeMappings = (Map)configurationContentTypeMappings.get(ALL_CONFIGURATIONS);
        if (contentTypeMappings == null) {
            return Collections.EMPTY_SET;
        }
        return contentTypeMappings.keySet();
    }

    static String createFilterKey(String configurationId, String contentTypeId) {
        return String.valueOf(configurationId) + CONTENT_TYPE_KEY_DELIMITER + contentTypeId;
    }

    private static class LanguageTableData {
        ICConfigurationDescription configuration;
        String contentTypeId;
        String languageId;

        LanguageTableData(ICConfigurationDescription configuration, String contentTypeId, String languageId) {
            this.configuration = configuration;
            this.contentTypeId = contentTypeId;
            this.languageId = languageId;
        }
    }
}

