/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CFileTypeDialog
extends Dialog {
    private Text fTextPattern;
    private Combo fComboType;
    private String fPattern;
    private IContentType fType;

    public CFileTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PreferencesMessages.CFileTypeDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getOkayButton().setEnabled(this.getPatternFromControl().length() > 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label pattern = new Label(composite, 0);
        pattern.setText(PreferencesMessages.CFileTypeDialog_patternLabel);
        this.fTextPattern = new Text(composite, 2052);
        this.fTextPattern.setLayoutData((Object)new GridData(768));
        if (this.fPattern != null) {
            this.fTextPattern.setText(this.fPattern);
        }
        this.fTextPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CFileTypeDialog.this.getOkayButton().setEnabled(CFileTypeDialog.this.getPatternFromControl().length() > 0);
            }
        });
        Label type = new Label(composite, 0);
        type.setText(PreferencesMessages.CFileTypeDialog_typeLabel);
        this.fComboType = new Combo(composite, 12);
        this.fComboType.setLayoutData((Object)new GridData(768));
        this.populateTypesCombo();
        return composite;
    }

    public void setPattern(String pattern) {
        this.fPattern = pattern;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public IContentType getContentType() {
        return this.fType;
    }

    private void populateTypesCombo() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        String[] ids = CoreModel.getRegistedContentTypeIds();
        ArrayList<IContentType> list = new ArrayList<IContentType>(ids.length);
        int i = 0;
        while (i < ids.length) {
            IContentType ctype = manager.getContentType(ids[i]);
            if (ctype != null) {
                list.add(ctype);
            }
            ++i;
        }
        IContentType[] ctypes = new IContentType[list.size()];
        list.toArray(ctypes);
        int index = -1;
        int i2 = 0;
        while (i2 < ctypes.length) {
            this.fComboType.add(ctypes[i2].getName());
            ++i2;
        }
        this.fComboType.setData((Object)ctypes);
        if (this.fType != null) {
            index = this.fComboType.indexOf(this.fType.getName());
        }
        this.fComboType.select(index < 0 ? 0 : index);
    }

    Button getOkayButton() {
        return this.getButton(0);
    }

    String getPatternFromControl() {
        return this.fTextPattern.getText().trim();
    }

    private IContentType getTypeFromControl() {
        IContentType type = null;
        int index = this.fComboType.getSelectionIndex();
        if (-1 != index) {
            String name = this.fComboType.getItem(index);
            IContentType[] types = (IContentType[])this.fComboType.getData();
            int i = 0;
            while (i < types.length) {
                if (name.equals(types[i].getName())) {
                    type = types[i];
                }
                ++i;
            }
        }
        return type;
    }

    protected void okPressed() {
        this.fPattern = this.getPatternFromControl();
        this.fType = this.getTypeFromControl();
        super.okPressed();
    }
}

