/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class PropertyAndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private Link fChangeWorkspaceSettings;
    private IStatus fBlockStatus = new StatusInfo();
    private Composite fParentComposite;
    private IProject fProject = null;
    private Map fData = null;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    static /* synthetic */ Class class$0;

    protected abstract Control createPreferenceContent(Composite var1);

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.fConfigurationBlockControl = this.createPreferenceContent(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean useProjectSettings() {
        return false;
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void setPreferenceContentStatus(IStatus status) {
        this.fBlockStatus = status;
        this.doStatusChanged();
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                PropertyAndPreferencePage.this.setPreferenceContentStatus(status);
            }
        };
    }

    protected IStatus getPreferenceContentStatus() {
        return this.fBlockStatus;
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.fBlockStatus);
        } else {
            this.updateStatus(new StatusInfo());
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fProject = (IProject)element.getAdapter((Class)clazz);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
        if (this.fChangeWorkspaceSettings != null && !this.offerLink()) {
            this.fChangeWorkspaceSettings.dispose();
            this.fParentComposite.layout(true, true);
        }
    }

    protected Map getData() {
        return this.fData;
    }
}

