/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class CContentAssistInvocationContext
extends ContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private final boolean fIsCompletion;
    private ITranslationUnit fTU = null;
    private boolean fTUComputed = false;
    private int fParseOffset = -1;
    private boolean fParseOffsetComputed = false;
    private IASTCompletionNode fCN = null;
    private boolean fCNComputed = false;
    private IIndex fIndex = null;
    private int fContextInfoPosition;

    public CContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor, boolean isCompletion) {
        super(viewer, offset);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fIsCompletion = isCompletion;
    }

    public CContentAssistInvocationContext(ITranslationUnit unit, boolean isCompletion) {
        this.fTU = unit;
        this.fTUComputed = true;
        this.fEditor = null;
        this.fIsCompletion = isCompletion;
    }

    public ITranslationUnit getTranslationUnit() {
        if (!this.fTUComputed) {
            this.fTUComputed = true;
            this.fTU = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        }
        return this.fTU;
    }

    public ICProject getProject() {
        ITranslationUnit unit = this.getTranslationUnit();
        return unit == null ? null : unit.getCProject();
    }

    public IASTCompletionNode getCompletionNode() {
        if (this.fCNComputed) {
            return this.fCN;
        }
        this.fCNComputed = true;
        int offset = this.getParseOffset();
        if (offset < 0) {
            return null;
        }
        ICProject proj = this.getProject();
        if (proj == null) {
            return null;
        }
        try {
            IIndexManager manager = CCorePlugin.getIndexManager();
            if (manager.isProjectIndexed(proj)) {
                this.fIndex = CCorePlugin.getIndexManager().getIndex(proj, 3);
                try {
                    this.fIndex.acquireReadLock();
                }
                catch (InterruptedException interruptedException) {
                    this.fIndex = null;
                }
            }
            int flags = 38;
            if (this.fIndex == null) {
                flags = 0;
            }
            this.fCN = this.fTU.getCompletionNode(this.fIndex, flags, offset);
        }
        catch (CoreException coreException) {}
        return this.fCN;
    }

    public int getParseOffset() {
        if (!this.fParseOffsetComputed) {
            this.fParseOffsetComputed = true;
            this.fContextInfoPosition = this.guessContextInformationPosition();
            this.fParseOffset = this.fIsCompletion ? this.guessCompletionPosition(this.getInvocationOffset()) : (this.fContextInfoPosition > 0 ? this.guessCompletionPosition(this.fContextInfoPosition) : -1);
        }
        return this.fParseOffset;
    }

    public int getContextInformationOffset() {
        this.getParseOffset();
        return this.fContextInfoPosition;
    }

    protected int guessCompletionPosition(int contextPosition) {
        int bound;
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int pos = scanner.findNonWhitespaceBackward(contextPosition - 1, bound = Math.max(-1, contextPosition - 200));
        if (pos == -1) {
            return contextPosition;
        }
        int token = scanner.previousToken(pos, bound);
        if (token == 11) {
            if ((pos = scanner.findOpeningPeer(pos, bound, '(', ')')) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
        }
        if (token == 5) {
            if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
            if (token == 14) {
                if ((pos = scanner.findOpeningPeer(pos - 1, '<', '>')) == -1) {
                    return contextPosition;
                }
                if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                    return contextPosition;
                }
                token = scanner.previousToken(pos, bound);
            }
            if (token == 2000) {
                return pos + 1;
            }
        }
        return contextPosition;
    }

    protected int guessContextInformationPosition() {
        int paren;
        int contextPosition = this.getInvocationOffset();
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) != -1) {
            int token = scanner.previousToken(paren - 1, bound);
            if (token == 2000 || token == 14) {
                return paren + 1;
            }
            pos = paren - 1;
        }
        return -1;
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    public boolean isContextInformationStyle() {
        return !this.fIsCompletion || this.getParseOffset() != this.getInvocationOffset();
    }

    public void dispose() {
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
        super.dispose();
    }
}

