/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.CommentContextType;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.TemplateContextType;

public class TemplateCompletionProposalComputer
implements ICompletionProposalComputer {
    private final TemplateEngine fCTemplateEngine;
    private final TemplateEngine fCommentTemplateEngine;

    public TemplateCompletionProposalComputer() {
        TemplateContextType contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.c");
        if (contextType == null) {
            contextType = new CContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fCTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
        contextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.comment");
        if (contextType == null) {
            contextType = new CommentContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fCommentTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        ITextViewer viewer = context.getViewer();
        int offset = context.getInvocationOffset();
        TemplateEngine engine = null;
        try {
            String partition = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"___c_partitioning", (int)offset, (boolean)true);
            if (partition.equals("__c_multiline_comment") || partition.equals("__c_singleline_comment")) {
                engine = this.fCommentTemplateEngine;
            } else if (this.isValidContext(context)) {
                engine = this.fCTemplateEngine;
            }
        }
        catch (BadLocationException badLocationException) {
            return Collections.EMPTY_LIST;
        }
        if (engine != null && context instanceof CContentAssistInvocationContext) {
            CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
            ITranslationUnit tUnit = cContext.getTranslationUnit();
            if (tUnit == null) {
                return Collections.EMPTY_LIST;
            }
            engine.reset();
            engine.complete(viewer, offset, tUnit);
            List result = engine.getResults();
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isValidContext(ContentAssistInvocationContext context) {
        int start;
        CHeuristicScanner scanner = new CHeuristicScanner(context.getDocument());
        return !scanner.looksLikeFieldReferenceBackward(start = context.getInvocationOffset(), Math.max(0, start - 100));
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        if (this.fCommentTemplateEngine != null) {
            this.fCommentTemplateEngine.reset();
        }
        if (this.fCTemplateEngine != null) {
            this.fCTemplateEngine.reset();
        }
    }
}

