/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.ide.IDE;

public class OpenExternalProblemAction
extends ActionDelegate
implements IObjectActionDelegate {
    IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void runWithEvent(IAction action, Event event) {
        Object object = this.selection.getFirstElement();
        if (object instanceof IMarker) {
            try {
                String externalLocation;
                Path externalPath;
                IEditorPart editor;
                IMarker marker = (IMarker)object;
                Object attributeObject = marker.getAttribute("problem.externalLocation");
                if (attributeObject instanceof String && (editor = EditorUtility.openInEditor((IPath)(externalPath = new Path(externalLocation = (String)attributeObject)), (ICElement)this.getCProject(marker))) != null) {
                    IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                }
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e.getStatus());
            }
        }
    }

    private ICProject getCProject(IMarker marker) {
        ICProject cproject = null;
        if (marker.getResource() instanceof IProject) {
            IProject project = (IProject)marker.getResource();
            cproject = CModelManager.getDefault().create(project);
        }
        return cproject;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        boolean enable = false;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IMarker) {
            try {
                IMarker marker = (IMarker)object;
                if (marker.isSubtypeOf("org.eclipse.cdt.core.problem") && marker.getAttribute("problem.externalLocation", null) != null) {
                    enable = true;
                }
                this.selection = (IStructuredSelection)selection;
                action.setEnabled(enable);
            }
            catch (CoreException coreException) {}
        }
    }
}

