/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;

public class ChangeConfigAction
extends Action {
    private String fConfigName = null;
    protected HashSet fProjects = null;

    public ChangeConfigAction(HashSet projects, String configName, String displayName, int accel) {
        super("&" + accel + " " + displayName);
        this.fProjects = projects;
        this.fConfigName = configName;
    }

    public void run() {
        Iterator iter = this.fProjects.iterator();
        while (iter.hasNext()) {
            IProject prj = (IProject)iter.next();
            ICProjectDescription prjd = CDTPropertyManager.getProjectDescription(prj);
            boolean changed = false;
            ICConfigurationDescription[] configs = prjd.getConfigurations();
            if (configs != null && configs.length > 0) {
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].getName().equals(this.fConfigName)) {
                        configs[i].setActive();
                        CDTPropertyManager.performOk(null);
                        AbstractPage.updateViews((IResource)prj);
                        changed = true;
                        break;
                    }
                    ++i;
                }
            }
            if (changed) continue;
            CDTPropertyManager.performCancel(null);
        }
    }
}

