/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ErrorParsTab
extends AbstractCPropertyTab {
    protected HashMap mapParsers = new HashMap();
    protected Table table;
    protected CheckboxTableViewer tv;
    ICConfigurationDescription cfgd;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new FillLayout());
        this.table = new Table(this.usercomp, 2084);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorParsTab.this.updateButtons();
            }
        });
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                ErrorParsTab.this.saveChecked();
            }
        });
        String[] stringArray = new String[5];
        stringArray[0] = MOVEUP_STR;
        stringArray[1] = MOVEDOWN_STR;
        stringArray[3] = UIMessages.getString("ErrorParsTab.0");
        stringArray[4] = UIMessages.getString("ErrorParsTab.1");
        this.initButtons(stringArray);
        this.initMapParsers();
    }

    protected void initMapParsers() {
        this.mapParsers.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "ErrorParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            int i = 0;
            while (i < exts.length) {
                if (exts[i].getConfigurationElements().length > 0) {
                    this.mapParsers.put(exts[i].getUniqueIdentifier(), exts[i].getLabel());
                }
                ++i;
            }
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.tv.setAllChecked(true);
                this.saveChecked();
                break;
            }
            case 4: {
                this.tv.setAllChecked(false);
                this.saveChecked();
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        TableData d = (TableData)this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked((Object)d);
        this.tv.remove((Object)d);
        n = up ? n - 1 : n + 1;
        this.tv.insert((Object)d, n);
        this.tv.setChecked((Object)d, checked);
        this.table.setSelection(n);
        this.saveChecked();
    }

    public void updateData(ICResourceDescription _cfgd) {
        String s;
        this.cfgd = _cfgd.getConfiguration();
        if (this.mapParsers == null) {
            return;
        }
        String[] ss = this.cfgd.getBuildSetting().getErrorParserIDs();
        ArrayList<TableData> data = new ArrayList<TableData>(this.mapParsers.size());
        ArrayList<TableData> checked = new ArrayList<TableData>(ss.length);
        HashMap cloneMap = new HashMap(this.mapParsers);
        int i = 0;
        while (i < ss.length) {
            s = (String)cloneMap.get(ss[i]);
            if (s != null) {
                TableData d = new TableData(ss[i], s);
                data.add(d);
                checked.add(d);
                cloneMap.remove(ss[i]);
            }
            ++i;
        }
        Iterator it = cloneMap.keySet().iterator();
        while (it.hasNext()) {
            s = (String)it.next();
            data.add(new TableData(s, (String)cloneMap.get(s)));
        }
        this.tv.setInput((Object)data.toArray());
        this.tv.setCheckedElements(checked.toArray());
        this.updateButtons();
    }

    public void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
        this.buttonSetEnabled(3, cnt > 0);
        this.buttonSetEnabled(4, cnt > 0);
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        String[] s1 = src.getConfiguration().getBuildSetting().getErrorParserIDs();
        dst.getConfiguration().getBuildSetting().setErrorParserIDs(s1);
    }

    private void saveChecked() {
        Object[] objs = this.tv.getCheckedElements();
        ArrayList<String> lst = new ArrayList<String>();
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                lst.add(((TableData)objs[i]).key);
                ++i;
            }
        }
        this.cfgd.getBuildSetting().setErrorParserIDs(lst.toArray(new String[lst.size()]));
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected void performDefaults() {
        this.cfgd.getConfiguration().getBuildSetting().setErrorParserIDs(null);
        this.updateData(this.getResDesc());
    }

    class TableData {
        String key;
        String value;

        public TableData(String _key, String _value) {
            this.key = _key;
            this.value = _value;
        }

        public String toString() {
            return this.value;
        }
    }
}

