/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class TemplateDrivenWizard
extends Wizard {
    protected List pagesBeforeTemplatePages = new ArrayList();
    protected List pagesAfterTemplatePages = new ArrayList();
    protected Template template;
    protected int pageIndex;
    protected Map templatePages;
    protected Composite pageContainer;
    protected List templatePagesOrderVector;

    public final void addPage(IWizardPage page) {
        page.setWizard((IWizard)this);
    }

    public final void addPages() {
        IWizardPage[] pages = this.getPagesBeforeTemplatePages();
        int i = 0;
        while (i < pages.length) {
            this.addPageBeforeTemplatePages(pages[i]);
            ++i;
        }
        pages = this.getPagesAfterTemplatePages();
        i = 0;
        while (i < pages.length) {
            this.addPageAfterTemplatePages(pages[i]);
            ++i;
        }
    }

    private void addPageBeforeTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesBeforeTemplatePages.add(page);
    }

    private void addPageAfterTemplatePages(IWizardPage page) {
        this.addPage(page);
        this.pagesAfterTemplatePages.add(page);
    }

    protected abstract IWizardPage[] getPagesBeforeTemplatePages();

    protected abstract IWizardPage[] getPagesAfterTemplatePages();

    protected abstract Template getTemplate();

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.pageIndex > this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size()) {
            --this.pageIndex;
            return (IWizardPage)this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        if (this.pageIndex > this.pagesBeforeTemplatePages.size()) {
            --this.pageIndex;
            return (IWizardPage)this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
            return (IWizardPage)this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        return null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() - 1) {
            ++this.pageIndex;
            return (IWizardPage)this.pagesBeforeTemplatePages.get(this.pageIndex);
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() - 1) {
            if (this.pageIndex == this.pagesBeforeTemplatePages.size() - 1) {
                Template template = this.getTemplate();
                if (this.template != null && !((Object)((Object)this.template)).equals((Object)template)) {
                    this.template = template;
                    this.templatePages = template.getUIPages();
                    this.templatePagesOrderVector = template.getPagesOrderVector();
                }
            }
            ++this.pageIndex;
            IWizardPage nextPage = (IWizardPage)this.templatePages.get(this.templatePagesOrderVector.get(this.pageIndex - this.pagesBeforeTemplatePages.size()));
            nextPage.setWizard((IWizard)this);
            if (nextPage.getControl() == null) {
                nextPage.createControl(this.pageContainer);
            }
            return nextPage;
        }
        if (this.pageIndex < this.pagesBeforeTemplatePages.size() + this.templatePagesOrderVector.size() + this.pagesAfterTemplatePages.size() - 1) {
            ++this.pageIndex;
            return (IWizardPage)this.pagesAfterTemplatePages.get(this.pageIndex - this.pagesBeforeTemplatePages.size() - this.templatePagesOrderVector.size());
        }
        return null;
    }

    public final boolean canFinish() {
        IWizardPage page;
        Iterator<Object> i = this.pagesBeforeTemplatePages.iterator();
        while (i.hasNext()) {
            page = (IWizardPage)i.next();
            if (page.isPageComplete()) continue;
            return false;
        }
        if (this.templatePages == null) {
            return false;
        }
        i = this.templatePages.values().iterator();
        while (i.hasNext()) {
            page = (IWizardPage)i.next();
            if (page.isPageComplete()) continue;
            return false;
        }
        i = this.pagesAfterTemplatePages.iterator();
        while (i.hasNext()) {
            page = (IWizardPage)i.next();
            if (page.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TemplateDrivenWizard.this.finishPage(monitor);
            }
        });
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private boolean finishPage(IProgressMonitor monitor) {
        IStatus[] statuses = this.template.executeTemplateProcesses(monitor, false);
        if (statuses.length == 1 && statuses[0].getException() instanceof ProcessFailureException) {
            TemplateEngineUIUtil.showError(statuses[0].getMessage(), statuses[0].getException());
            return false;
        }
        String msg = Messages.getString("TemplateDrivenWizard.0");
        TemplateEngineUIUtil.showStatusDialog(msg, (IStatus)new MultiStatus(CUIPlugin.getPluginId(), 0, statuses, msg, null));
        return true;
    }

    public final void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.pageContainer = pageContainer;
    }
}

