/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.browser.util.IndexModelUtil;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeSelectionDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ElementSelectionDialog
extends TypeSelectionDialog {
    private static final ISchedulingRule SINGLE_INSTANCE_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private char[] fCurrentPrefix = null;
    private Job fUpdateJob;
    private boolean fAllowEmptyPrefix = true;
    private boolean fAllowEmptyString = true;
    private ProgressMonitorPart fProgressMonitorPart;
    private String fHelpContextId;

    public ElementSelectionDialog(Shell parent) {
        super(parent);
        this.setMatchEmptyString(false);
        this.fUpdateJob = new UpdateElementsJob(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_name);
        this.fUpdateJob.setRule(SINGLE_INSTANCE_RULE);
    }

    public void create() {
        super.create();
        this.scheduleUpdate(this.getFilter());
    }

    public boolean close() {
        this.fUpdateJob.cancel();
        return super.close();
    }

    public void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
        this.setHelpAvailable(this.fHelpContextId != null);
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        super.setMatchEmptyString(matchEmptyString);
        this.fAllowEmptyString = matchEmptyString;
        if (matchEmptyString) {
            this.setAllowEmptyPrefix(true);
        }
    }

    public void setAllowEmptyPrefix(boolean allowEmptyPrefix) {
        this.fAllowEmptyPrefix = allowEmptyPrefix;
    }

    protected boolean showLowLevelFilter() {
        return false;
    }

    public Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.fHelpContextId);
        return super.createDialogArea(parent);
    }

    protected Table createLowerList(Composite parent) {
        Table table = super.createLowerList(parent);
        this.createProgressMonitorPart(parent);
        return table;
    }

    private void createProgressMonitorPart(Composite parent) {
        this.fProgressMonitorPart = new ProgressMonitorPart(parent, (Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 0;
        gridData.verticalAlignment = 1;
        this.fProgressMonitorPart.setLayoutData((Object)gridData);
        Label separator = new Label(parent.getParent(), 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fUpdateJob.addJobChangeListener((IJobChangeListener)new UpdateJobListener((IProgressMonitor)this.fProgressMonitorPart));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ITypeInfo[] getElementsByPrefix(char[] prefix, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        types = new HashSet<IndexTypeInfo>();
        if (prefix == null) return types.toArray(new ITypeInfo[types.size()]);
        filter = new IndexFilter(){

            public boolean acceptBinding(IBinding binding) throws CoreException {
                if (ElementSelectionDialog.this.isVisibleType(IndexModelUtil.getElementType((IBinding)binding)) && IndexFilter.ALL_DECLARED.acceptBinding(binding)) {
                    return !((IIndexBinding)binding).isFileLocal();
                }
                return false;
            }
        };
        try {
            block13: {
                block14: {
                    index = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProjects());
                    try {
                        index.acquireReadLock();
                        bindings = index.findBindingsForPrefix(prefix, false, filter, monitor);
                        i = 0;
                        while (true) {
                            if (i >= bindings.length) {
                                if (this.isVisibleType(79)) {
                                    macros = index.findMacrosForPrefix(prefix, IndexFilter.ALL_DECLARED, monitor);
                                    i = 0;
                                    break;
                                }
                                break block13;
                            }
                            if (i % 4096 == 0 && monitor.isCanceled()) {
                                while (true) {
                                    var10_13 = null;
                                    break block14;
                                    break;
                                }
                            }
                            typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexBinding)bindings[i]);
                            types.add(typeinfo);
                            ++i;
                        }
                        while (i < macros.length) {
                            if (i % 4096 == 0 && monitor.isCanceled()) ** continue;
                            typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexMacro)macros[i]);
                            types.add(typeinfo);
                            ++i;
                        }
                        break block13;
                    }
                    catch (Throwable var11_17) {
                        var10_14 = null;
                        index.releaseReadLock();
                        throw var11_17;
                    }
                }
                index.releaseReadLock();
                return null;
            }
            var10_15 = null;
            index.releaseReadLock();
            return types.toArray(new ITypeInfo[types.size()]);
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
            return types.toArray(new ITypeInfo[types.size()]);
        }
        catch (InterruptedException ie) {
            CCorePlugin.log((Throwable)ie);
        }
        return types.toArray(new ITypeInfo[types.size()]);
    }

    protected final void setListElements(Object[] elements) {
        super.setListElements(elements);
    }

    public void setElements(Object[] elements) {
        throw new UnsupportedOperationException();
    }

    protected void handleEmptyList() {
        this.updateOkState();
    }

    protected Text createFilterText(Composite parent) {
        final Text result = super.createFilterText(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ElementSelectionDialog.this.scheduleUpdate(result.getText());
            }
        };
        result.addListener(24, listener);
        return result;
    }

    protected void scheduleUpdate(String filterText) {
        boolean needQuery;
        char[] newPrefix = this.toPrefix(filterText);
        boolean equivalentPrefix = this.isEquivalentPrefix(this.fCurrentPrefix, newPrefix);
        boolean emptyQuery = newPrefix.length == 0 && !this.fAllowEmptyPrefix || filterText.length() == 0 && !this.fAllowEmptyString;
        boolean bl = needQuery = !equivalentPrefix;
        if (emptyQuery) {
            newPrefix = null;
            boolean bl2 = needQuery = needQuery || this.fCurrentPrefix != null;
        }
        if (needQuery || this.fUpdateJob.getState() == 2 || this.fUpdateJob.getState() == 1) {
            this.fUpdateJob.cancel();
            this.fCurrentPrefix = newPrefix;
            this.fUpdateJob.schedule(200L);
        }
    }

    private char[] toPrefix(String userFilter) {
        QualifiedTypeName qualifiedName = new QualifiedTypeName(userFilter);
        if (qualifiedName.segmentCount() > 1) {
            userFilter = qualifiedName.lastSegment();
        }
        if (userFilter.endsWith("<")) {
            userFilter = userFilter.substring(0, userFilter.length() - 1);
        }
        int asterisk = userFilter.indexOf("*");
        int questionMark = userFilter.indexOf("?");
        int prefixEnd = asterisk < 0 ? questionMark : (questionMark < 0 ? asterisk : Math.min(asterisk, questionMark));
        return (prefixEnd == -1 ? userFilter : userFilter.substring(0, prefixEnd)).toCharArray();
    }

    private boolean isEquivalentPrefix(char[] currentPrefix, char[] newPrefix) {
        if (currentPrefix == null || currentPrefix.length > newPrefix.length) {
            return false;
        }
        if (newPrefix.length == currentPrefix.length) {
            return Arrays.equals(currentPrefix, newPrefix);
        }
        return new String(currentPrefix).equals(new String(newPrefix, 0, currentPrefix.length));
    }

    static /* synthetic */ void access$1(ElementSelectionDialog elementSelectionDialog) {
        elementSelectionDialog.updateOkState();
    }

    private class UpdateElementsJob
    extends Job {
        public UpdateElementsJob(String name) {
            super(name);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        public IStatus run(IProgressMonitor monitor) {
            Shell shell;
            monitor.beginTask(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_inProgress, -1);
            ITypeInfo[] elements = ElementSelectionDialog.this.getElementsByPrefix(ElementSelectionDialog.this.fCurrentPrefix, monitor);
            if (elements != null && !monitor.isCanceled() && (shell = ElementSelectionDialog.this.getShell()) != null && !shell.isDisposed()) {
                Runnable update = new Runnable(this, shell, monitor, elements){
                    final /* synthetic */ UpdateElementsJob this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    private final /* synthetic */ ITypeInfo[] val$elements;
                    {
                        this.this$1 = updateElementsJob;
                        this.val$shell = shell;
                        this.val$monitor = iProgressMonitor;
                        this.val$elements = iTypeInfoArray;
                    }

                    public void run() {
                        if (!this.val$shell.isDisposed() && !this.val$monitor.isCanceled()) {
                            UpdateElementsJob.access$0(this.this$1).setListElements(this.val$elements);
                            ElementSelectionDialog.access$1(UpdateElementsJob.access$0(this.this$1));
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }

        static /* synthetic */ ElementSelectionDialog access$0(UpdateElementsJob updateElementsJob) {
            return updateElementsJob.ElementSelectionDialog.this;
        }
    }

    private final class UpdateJobListener
    extends JobChangeAdapter {
        boolean fDone;
        private IProgressMonitor fMonitor;

        private UpdateJobListener(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void done(IJobChangeEvent event) {
            this.fDone = true;
            Shell shell = ElementSelectionDialog.this.getShell();
            if (shell != null && !shell.isDisposed()) {
                Runnable update = new Runnable(this, shell){
                    final /* synthetic */ UpdateJobListener this$1;
                    private final /* synthetic */ Shell val$shell;
                    {
                        this.this$1 = updateJobListener;
                        this.val$shell = shell;
                    }

                    public void run() {
                        if (!this.val$shell.isDisposed() && this.this$1.fDone) {
                            UpdateJobListener.access$0(this.this$1).done();
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
            }
        }

        public void running(IJobChangeEvent event) {
            this.fDone = false;
            Shell shell = ElementSelectionDialog.this.getShell();
            if (shell != null && !shell.isDisposed()) {
                Runnable update = new Runnable(this, shell){
                    final /* synthetic */ UpdateJobListener this$1;
                    private final /* synthetic */ Shell val$shell;
                    {
                        this.this$1 = updateJobListener;
                        this.val$shell = shell;
                    }

                    public void run() {
                        if (!this.val$shell.isDisposed() && !this.this$1.fDone) {
                            UpdateJobListener.access$0(this.this$1).beginTask(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_inProgress, -1);
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
            }
        }

        static /* synthetic */ IProgressMonitor access$0(UpdateJobListener updateJobListener) {
            return updateJobListener.fMonitor;
        }
    }
}

