/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ExternalSearchAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final IStorage fStorage;
    private final int fDepth;
    private final String fLocationAttribute;

    public ExternalSearchAnnotationModel(IResource markerResource, IStorage storage) {
        this(markerResource, storage, 0, "problem.externalLocation");
    }

    ExternalSearchAnnotationModel(IResource markerResource, IStorage storage, int depth) {
        this(markerResource, storage, depth, "problem.externalLocation");
    }

    ExternalSearchAnnotationModel(IResource markerResource, IStorage storage, int depth, String locationAttribute) {
        super(markerResource);
        this.fStorage = storage;
        this.fDepth = depth;
        this.fLocationAttribute = locationAttribute;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] markers = null;
        if (this.getResource() != null) {
            markers = this.getResource().findMarkers("org.eclipse.core.resources.marker", true, this.fDepth);
        }
        return markers;
    }

    protected boolean isAcceptable(IMarker marker) {
        boolean acceptable = false;
        String externalFileName = marker.getAttribute(this.fLocationAttribute, null);
        if (externalFileName != null) {
            Path externalPath = new Path(externalFileName);
            IPath storagePath = this.fStorage.getFullPath();
            acceptable = externalPath.equals((Object)storagePath);
        }
        return acceptable;
    }
}

